/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.misc;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestActivityModelsCollection;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestFavoriteSiteModel;
import org.alfresco.rest.model.RestPersonFavoritesModelsCollection;
import org.alfresco.rest.model.RestRatingModel;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.rest.model.RestSiteMembershipRequestModelsCollection;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.ActivityType;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class FunctionalCasesTests
extends RestTest {
    private RestSiteMemberModel updatedMember;
    private RestSiteMembershipRequestModelsCollection returnedCollection;
    private RestFavoriteSiteModel restFavoriteSiteModel;
    private RestActivityModelsCollection activities;
    private FileModel file;

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager is able to update manager with different roles and gets status code CREATED (201)")
    public void managerIsAbleToUpdateManagerWithDifferentRoles() {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(publicSite).addPerson(testUser).assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        testUser.setUserRole(UserRole.SiteCollaborator);
        this.updatedMember = this.restClient.withCoreAPI().usingSite(publicSite).updateSiteMember(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        testUser.setUserRole(UserRole.SiteContributor);
        this.updatedMember = this.restClient.withCoreAPI().usingSite(publicSite).updateSiteMember(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        testUser.setUserRole(UserRole.SiteConsumer);
        this.updatedMember = this.restClient.withCoreAPI().usingSite(publicSite).updateSiteMember(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager is able to update consumer with different roles and gets status code CREATED (201)")
    public void managerIsAbleToUpdateConsumerWithDifferentRoles() {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(publicSite).addPerson(testUser).assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        testUser.setUserRole(UserRole.SiteContributor);
        this.updatedMember = this.restClient.withCoreAPI().usingSite(publicSite).updateSiteMember(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        testUser.setUserRole(UserRole.SiteCollaborator);
        this.updatedMember = this.restClient.withCoreAPI().usingSite(publicSite).updateSiteMember(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        testUser.setUserRole(UserRole.SiteManager);
        this.updatedMember = this.restClient.withCoreAPI().usingSite(publicSite).updateSiteMember(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.updatedMember.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Approve request, add site to favorites, then delete it from favorites")
    @Test(groups={"rest-api", "people", "regression"})
    public void approveRequestAddAndDeleteSiteFromFavorites() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createModeratedRandomSite();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(newMember).withWorkflowAPI().getTasks().getTaskModelByDescription(moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), taskModel.getId(), true, "Approve");
        this.returnedCollection = this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCollection.assertThat().entriesListDoesNotContain("id", moderatedSite.getId());
        this.restFavoriteSiteModel = this.restClient.authenticateUser(newMember).withCoreAPI().usingUser(newMember).addFavoriteSite(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)moderatedSite.getId());
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().removeFavoriteSite(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Reject request, add moderated site to favorites, create request again and approve it")
    @Test(groups={"rest-api", "people", "regression"})
    public void rejectRequestAddModeratedSiteToFavorites() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createModeratedRandomSite();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(newMember).withWorkflowAPI().getTasks().getTaskModelByDescription(moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), taskModel.getId(), false, "Rejected");
        this.returnedCollection = this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCollection.assertThat().entriesListDoesNotContain("id", moderatedSite.getId());
        this.restFavoriteSiteModel = this.restClient.authenticateUser(newMember).withCoreAPI().usingUser(newMember).addFavoriteSite(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)moderatedSite.getId());
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        taskModel = this.restClient.authenticateUser(newMember).withWorkflowAPI().getTasks().getTaskModelByDescription(moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), taskModel.getId(), true, "Accept");
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(newMember).deleteSiteMember(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingSite(moderatedSite).getSiteMembers().assertThat().entriesListDoesNotContain("id", newMember.getUsername());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Add a file and check that activity is included in person activities")
    public void addFileThenGetPersonActivities() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        this.file = ((DataContent)this.dataContent.usingUser(manager).usingSite(publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.activities = this.restClient.authenticateUser(manager).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(3);
        ((RestModels)((RestModels)((RestModels)this.activities.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", publicSite.getId())).and().entriesListContains("activityType", "org.alfresco.documentlibrary.file-added")).and().entriesListContains("activitySummary.objectId", this.file.getNodeRefWithoutVersion());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Add a comment to a file and check that activity is included in person activities")
    public void addCommentThenGetPersonActivities() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        this.file = ((DataContent)this.dataContent.usingUser(manager).usingSite(publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(manager).withCoreAPI().usingResource((RepoTestModel)this.file).addComment("new comment");
        this.activities = this.restClient.authenticateUser(manager).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(4);
        ((RestModels)((RestModels)((RestModels)this.activities.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", publicSite.getId())).and().entriesListContains("activityType", "org.alfresco.comments.comment-created")).and().entriesListContains("activitySummary.objectId", this.file.getNodeRefWithoutVersion());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Add a file, delete it and check that activity is included in person activities")
    public void addFileDeleteItThenGetPersonActivities() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        this.file = ((DataContent)this.dataContent.usingUser(manager).usingSite(publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataContent)this.dataContent.usingUser(manager).usingResource((ContentModel)this.file)).deleteContent();
        this.activities = this.restClient.authenticateUser(manager).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(4);
        ((RestModels)((RestModels)((RestModels)this.activities.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", publicSite.getId())).and().entriesListContains("activityType", "org.alfresco.documentlibrary.file-deleted")).and().entriesListContains("activitySummary.objectId", this.file.getNodeRefWithoutVersion());
    }

    @Test(groups={"rest-api", "comments", "regression"})
    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add comment to a file, then get comment details. Update it and check that get comment returns updated details. Delete comment then check that file has no comments.")
    public void addUpdateDeleteCommentThenGetCommentDetails() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        this.file = ((DataContent)this.dataContent.usingUser(manager).usingSite(publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel newComment = this.restClient.authenticateUser(manager).withCoreAPI().usingResource((RepoTestModel)this.file).addComment("new comment");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestCommentModelsCollection fileComments = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        fileComments.assertThat().entriesListContains("content", newComment.getContent());
        RestCommentModel updatedComment = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).updateComment(newComment, "updated comment");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        fileComments = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)fileComments.assertThat().entriesListContains("content", updatedComment.getContent())).assertThat().entriesListDoesNotContain("content", newComment.getContent());
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).deleteComment(updatedComment);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        fileComments = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        fileComments.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "comments", "regression"})
    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add a comment to a file, delete it, then added the same comment again.")
    public void checkThatADeletedCommentCanBePostedAgain() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        this.file = ((DataContent)this.dataContent.usingUser(manager).usingSite(publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel newComment = this.restClient.authenticateUser(manager).withCoreAPI().usingResource((RepoTestModel)this.file).addComment("new comment");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestCommentModelsCollection fileComments = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        fileComments.assertThat().entriesListContains("content", newComment.getContent());
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).deleteComment(newComment);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        fileComments = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        fileComments.assertThat().entriesListIsEmpty();
        this.restClient.authenticateUser(manager).withCoreAPI().usingResource((RepoTestModel)this.file).addComment("new comment");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        fileComments = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        fileComments.assertThat().entriesListContains("content", newComment.getContent());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Create an user, join the user to a site and check that activity is included in person activities")
    public void joinUserToSiteThenGetPersonActivities() throws Exception {
        UserModel userJoinSite = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.restClient.authenticateUser(userJoinSite).withCoreAPI().usingMe().addSiteMembershipRequest(publicSite);
        this.activities = this.restClient.withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(1);
        ((RestModels)((RestModels)((RestModels)this.activities.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", publicSite.getId())).and().entriesListContains("activityType", "org.alfresco.site.user-joined")).and().entriesListContains("activitySummary.memberPersonId", userJoinSite.getUsername());
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify membership request by user after it was removed from site gets status code 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void userCanNotCreateMembershipRequestIfItWasRemovedFromPrivateSite() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        newMember.setUserRole(UserRole.SiteCollaborator);
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPrivateRandomSite();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(privateSite).addPerson(newMember).assertThat().field("id").is((Object)newMember.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(newMember).deleteSiteMember(privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, newMember.getUsername(), privateSite.getTitle()));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user can be added back after if was removed from site")
    @Test(groups={"rest-api", "people", "regression"})
    public void userCanBeAddedAfterItWasRemovedFromSite() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        newMember.setUserRole(UserRole.SiteCollaborator);
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createModeratedRandomSite();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(newMember).withWorkflowAPI().getTasks().getTaskModelByDescription(moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), taskModel.getId(), true, "Accept");
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(newMember).deleteSiteMember(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingSite(moderatedSite).getSiteMembers().assertThat().entriesListDoesNotContain("id", newMember.getUsername());
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(moderatedSite).addPerson(newMember).assertThat().field("id").is((Object)newMember.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingSite(moderatedSite).getSiteMembers().assertThat().entriesListContains("id", newMember.getUsername());
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Check that a comment of a document was also removed after deleting the document")
    @Test(groups={"rest-api", "comments", "regression"})
    public void checkTheCommentOfADocumentThatWasDeletedDoesNotExist() throws Exception {
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.file = ((DataContent)this.dataContent.usingSite(publicSite)).usingUser(this.dataUser.getAdminUser()).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String newContent = "This is a new comment added by " + this.dataUser.getAdminUser().getUsername();
        ((RestCommentModel)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(newContent).assertThat().field("content").isNotEmpty()).and().field("content").is((Object)newContent);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((DataContent)this.dataContent.usingUser(this.dataUser.getAdminUser()).usingResource((ContentModel)this.file)).deleteContent();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, this.file.getNodeRefWithoutVersion()));
    }

    @Bug(id="REPO-4854")
    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Check that a comment of a document from a private site is not deleted after user is removed")
    @Test(groups={"rest-api", "comments", "regression"})
    public void checkThatCommentIsNotDeletedWhenPrivateSiteMemberIsRemoved() throws Exception {
        UserModel newUser = this.dataUser.createRandomTestUser();
        newUser.setUserRole(UserRole.SiteManager);
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPrivateRandomSite();
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(privateSite).addPerson(newUser);
        this.file = ((DataContent)this.dataContent.usingSite(privateSite)).usingUser(this.dataUser.getAdminUser()).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String newContent = "This is a new comment added by " + newUser.getUsername();
        ((RestCommentModel)this.restClient.authenticateUser(newUser).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(newContent).assertThat().field("content").isNotEmpty()).and().field("content").is((Object)newContent);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(privateSite).deleteSiteMember(newUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Utility.sleep((int)200, (int)30000, () -> this.restClient.withCoreAPI().usingSite(privateSite).getSiteMembers().assertThat().entriesListDoesNotContain("id", newUser.getUsername()));
        RestCommentModelsCollection comments = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)comments.assertThat().entriesListContains("content", newContent)).and().entriesListContains("createdBy.id", newUser.getUsername());
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add one file to favorites then add a comment to this file")
    @Test(groups={"rest-api", "comments", "regression"})
    public void commentAFavoriteFile() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        this.file = ((DataContent)this.dataContent.usingSite(publicSite)).usingUser(this.dataUser.getAdminUser()).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(manager).withCoreAPI().usingMe().addFileToFavorites(this.file);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListContains("targetGuid", this.file.getNodeRefWithoutVersion());
        RestCommentModel comment = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).addComment("new comment");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        comment.assertThat().field("content").is((Object)"new comment");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Remove one file from favorites then add a comment to this file")
    @Test(groups={"rest-api", "comments", "regression"})
    public void commentFileRemovedFromFavorites() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        this.file = ((DataContent)this.dataContent.usingSite(publicSite)).usingUser(this.dataUser.getAdminUser()).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(manager).withCoreAPI().usingMe().addFileToFavorites(this.file);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingMe().deleteFileFromFavorites(this.file);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.file.getNodeRefWithoutVersion());
        RestCommentModel comment = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).addComment("new comment");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        comment.assertThat().field("content").is((Object)"new comment");
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check favorite sites after a favorite site visibility is changed")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void changeFavoriteSiteVisibilityThenCheckFavorites() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(manager, publicSite, UserRole.SiteManager);
        SiteModel favoriteSite = ((DataSite)this.dataSite.usingUser(manager)).createPublicRandomSite();
        UserModel regularUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(regularUser).withCoreAPI().usingAuthUser().addSiteToFavorites(favoriteSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestPersonFavoritesModelsCollection userFavoriteSites = this.restClient.withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)userFavoriteSites.assertThat().entriesListContains("targetGuid", favoriteSite.getGuid())).assertThat().entriesListContains("target.site.visibility", favoriteSite.getVisibility().name())).assertThat().entriesListContains("target.site.id", favoriteSite.getId());
        ((DataSite)this.dataSite.usingUser(manager)).updateSiteVisibility(favoriteSite, SiteService.Visibility.MODERATED);
        userFavoriteSites = this.restClient.authenticateUser(regularUser).withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)userFavoriteSites.assertThat().entriesListContains("targetGuid", favoriteSite.getGuid())).assertThat().entriesListContains("target.site.visibility", "MODERATED")).assertThat().entriesListContains("target.site.id", favoriteSite.getId());
        ((DataSite)this.dataSite.usingUser(manager)).updateSiteVisibility(favoriteSite, SiteService.Visibility.PRIVATE);
        userFavoriteSites = this.restClient.authenticateUser(regularUser).withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        userFavoriteSites.assertThat().entriesListIsEmpty();
        ((DataSite)this.dataSite.usingUser(manager)).updateSiteVisibility(favoriteSite, SiteService.Visibility.PUBLIC);
        userFavoriteSites = this.restClient.authenticateUser(regularUser).withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)userFavoriteSites.assertThat().entriesListContains("targetGuid", favoriteSite.getGuid())).assertThat().entriesListContains("target.site.visibility", favoriteSite.getVisibility().name())).assertThat().entriesListContains("target.site.id", favoriteSite.getId());
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that a user who joins a moderated site as manager is able to comment, rate, tag an existing file from the site, add site to favorites, add and remove site members.")
    @Test(groups={"rest-api", "sites", "regression"})
    public void checkNewManagerActions() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createModeratedRandomSite();
        this.file = ((DataContent)this.dataContent.usingSite(moderatedSite)).usingUser(this.dataUser.getAdminUser()).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().addSiteMembershipRequest(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.withWorkflowAPI().getTasks().getTaskModelByDescription(moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), taskModel.getId(), true, "Approve");
        this.returnedCollection = this.restClient.withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedCollection.assertThat().entriesListDoesNotContain("id", moderatedSite.getId());
        newMember.setUserRole(UserRole.SiteManager);
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(moderatedSite).updateSiteMember(newMember).assertThat().field("id").is((Object)newMember.getUsername())).and().field("role").is((Object)newMember.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestCommentModel comment = this.restClient.authenticateUser(newMember).withCoreAPI().usingResource((RepoTestModel)this.file).addComment("new comment");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        comment.assertThat().field("content").is((Object)"new comment");
        RestRatingModel returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
        returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
        RestTagModel tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.file).addTag("filetag");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestTagModel)tag.assertThat().field("tag").is((Object)"filetag")).and().field("id").isNotEmpty();
        this.restFavoriteSiteModel = this.restClient.withCoreAPI().usingAuthUser().addFavoriteSite(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)moderatedSite.getId());
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(moderatedSite).addPerson(testUser).assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingSite(moderatedSite).deleteSiteMember(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingSite(moderatedSite).getSiteMembers().assertThat().entriesListDoesNotContain("id", testUser.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Bug(id="REPO-1830")
    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its activities with Rest API and response is successful")
    public void userGetsItsPeopleActivities() throws Exception {
        UserModel newUser = this.dataUser.createRandomTestUser();
        SiteModel userSiteModel = ((DataSite)this.dataSite.usingUser(this.dataUser.getAdminUser())).createPublicRandomSite();
        this.dataUser.addUserToSite(newUser, userSiteModel, UserRole.SiteCollaborator);
        ((DataContent)this.dataContent.usingUser(newUser).usingSite(userSiteModel)).createFolder();
        FileModel fileInSite = ((DataContent)this.dataContent.usingUser(newUser).usingSite(userSiteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String newContent = "This is a new comment added by " + newUser.getUsername();
        RestCommentModel commentModel = this.restClient.authenticateUser(newUser).withCoreAPI().usingResource((RepoTestModel)fileInSite).addComment(newContent);
        this.restClient.authenticateUser(newUser).withCoreAPI().usingResource((RepoTestModel)fileInSite).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)fileInSite).updateComment(commentModel, "new Content");
        newUser.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(userSiteModel).updateSiteMember(newUser);
        this.restClient.authenticateUser(newUser).withCoreAPI().usingResource((RepoTestModel)fileInSite).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)fileInSite).deleteComment(commentModel);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(userSiteModel).deleteSiteMember(newUser);
        RestActivityModelsCollection restActivityModelsCollection = this.restClient.authenticateUser(newUser).withCoreAPI().usingMe().getPersonActivitiesUntilEntriesCountIs(10);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        restActivityModelsCollection.assertThat().paginationField("count").is("10");
        restActivityModelsCollection = this.restClient.authenticateUser(newUser).withCoreAPI().usingMe().getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        restActivityModelsCollection.assertThat().paginationField("count").is("10");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)restActivityModelsCollection.assertThat().entriesListContains("activityType", ActivityType.USER_JOINED.toString())).assertThat().entriesListContains("activityType", ActivityType.FILE_ADDED.toString())).assertThat().entriesListContains("activityType", ActivityType.FOLDER_ADDED.toString())).assertThat().entriesListContains("activityType", ActivityType.COMMENT_CREATED.toString())).assertThat().entriesListContains("activityType", ActivityType.FILE_LIKED.toString())).assertThat().entriesListContains("activityType", ActivityType.COMMENT_UPDATED.toString())).assertThat().entriesListContains("activityType", ActivityType.USER_ROLE_CHANGED.toString())).assertThat().entriesListContains("activityType", ActivityType.COMMENT_DELETED.toString())).assertThat().entriesListContains("activityType", ActivityType.USER_LEFT.toString());
    }
}

