/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Ignore;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class UpdateTagTests
extends TagsDataPrep {
    private RestTagModel oldTag;
    private String randomTag = "";

    @BeforeMethod(alwaysRun=true)
    public void addTagToDocument() {
        this.restClient.authenticateUser(adminUserModel);
        this.oldTag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"old").toLowerCase());
        this.randomTag = RandomData.getRandomName((String)"tag").toLowerCase();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Admin user updates tags and status code is 200")
    @Bug(id="REPO-1828")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void adminIsAbleToUpdateTags() {
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)this.randomTag);
        returnedModel.assertThat().field("id").isNotNull();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void managerIsNotAbleToUpdateTag() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void collaboratorIsNotAbleToUpdateTagCheckDefaultErrorModelSchema() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsNotAbleToUpdateTag() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Consumer user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void consumerIsNotAbleToUpdateTag() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void userIsNotAbleToUpdateTagIfAuthenticationFails() {
        UserModel siteManager = usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        String managerPassword = siteManager.getPassword();
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager);
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        siteManager.setPassword(managerPassword);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid id")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithInvalidId() {
        String invalidTagId = "invalid-id";
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag").toLowerCase());
        tag.setId(invalidTagId);
        this.restClient.withCoreAPI().usingTag(tag).update(RandomData.getRandomName((String)"tag").toLowerCase());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, invalidTagId));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with empty id")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithEmptyId() {
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag").toLowerCase());
        tag.setId("");
        this.restClient.withCoreAPI().usingTag(tag).update(RandomData.getRandomName((String)"tag").toLowerCase());
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.PUT_EMPTY_ARGUMENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid body")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithEmptyBody() {
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag").toLowerCase());
        this.restClient.withCoreAPI().usingTag(tag).update("");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.BLANK_TAG);
    }

    @Bug(id="ACE-5629")
    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid body containing '|' symbol")
    @Test(groups={"rest-api", "tags", "regression"})
    @Ignore
    public void adminIsNotAbleToUpdateTagWithInvalidBodyScenario1() {
        String invalidTagBody = "|.\"/<>*";
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag").toLowerCase());
        try {
            Utility.sleep((int)500, (int)20000, () -> {
                this.restClient.withCoreAPI().usingTag(tag).update(invalidTagBody);
                this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_TAG, invalidTagBody));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Test interrupted while waiting for error status code.");
        }
    }

    @Bug(id="ACE-5629")
    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid body without '|' symbol")
    @Test(groups={"rest-api", "tags", "regression"})
    @Ignore
    public void adminIsNotAbleToUpdateTagWithInvalidBodyScenario2() {
        String invalidTagBody = ".\"/<>*";
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        try {
            Utility.sleep((int)500, (int)20000, () -> {
                this.restClient.withCoreAPI().usingTag(tag).update(invalidTagBody);
                this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_TAG, invalidTagBody));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Test interrupted while waiting for error status code.");
        }
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user can provide large string for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    @Ignore
    public void adminIsAbleToUpdateTagsProvideLargeStringTag() {
        String largeStringTag = RandomStringUtils.randomAlphanumeric((int)10000).toLowerCase();
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(largeStringTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)largeStringTag);
        returnedModel.assertThat().field("id").isNotNull();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user can provide short string for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    public void adminIsAbleToUpdateTagsProvideShortStringTag() {
        String shortStringTag = RandomStringUtils.randomAlphanumeric((int)2).toLowerCase();
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(shortStringTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)shortStringTag);
        returnedModel.assertThat().field("id").isNotNull();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user can provide string with special chars for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    @Ignore
    public void adminIsAbleToUpdateTagsProvideSpecialCharsStringTag() {
        String specialCharsString = RandomData.getRandomName((String)"!@#$%^&*()'\".,<>-_+=|\\").toLowerCase();
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(specialCharsString);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)specialCharsString);
        returnedModel.assertThat().field("id").isNotNull();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can provide existing tag for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    @Ignore
    public void adminIsAbleToUpdateTagsProvideExistingTag() {
        String existingTag = RandomData.getRandomName((String)"oldTag").toLowerCase();
        RestTagModel oldExistingTag = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).addTag(existingTag);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(oldExistingTag).update(existingTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)existingTag);
        returnedModel.assertThat().field("id").isNotNull();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can delete a tag, add tag and update it.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    @Ignore
    public void adminDeleteTagAddTagUpdateTag() {
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.oldTag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        String newTag = RandomData.getRandomName((String)"addTag").toLowerCase();
        RestTagModel newTagModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        returnedModel = this.restClient.withCoreAPI().usingTag(newTagModel).update(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)newTag);
        returnedModel.assertThat().field("id").isNotNull();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can update a tag, delete tag and add it.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    @Ignore
    public void adminUpdateTagDeleteTagAddTag() {
        String newTag = RandomData.getRandomName((String)"addTag").toLowerCase();
        returnedModel = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingTag(this.oldTag).update(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)newTag);
        returnedModel.assertThat().field("id").isNotNull();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(returnedModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Admin user updates orphan tags and status code is 200")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void adminIsAbleToUpdateOrphanTag() {
        Step.STEP((String)"Update orphan tag and expect 200");
        String newTagName = RandomData.getRandomName((String)"new").toLowerCase();
        returnedModel = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingTag(orphanTag).update(newTagName);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestTagModel expected = RestTagModel.builder().id(orphanTag.getId()).tag(newTagName).create();
        returnedModel.assertThat().isEqualTo((Object)expected, new String[0]);
    }

    @Test(groups={"rest-api", "tags"})
    public void canUpdateTagAndGetCount() {
        Step.STEP((String)"Create an orphaned tag");
        String tagName = RandomData.getRandomName((String)"tag").toLowerCase();
        RestTagModel createdTag = RestTagModel.builder().tag(tagName).create();
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().createSingleTag(createdTag);
        Step.STEP((String)"Update tag and request the count field");
        String newTagName = RandomData.getRandomName((String)"new").toLowerCase();
        returnedModel = ((RestCoreAPI)this.restClient.authenticateUser(adminUserModel).withCoreAPI().include(new String[]{"count"})).usingTag(tag).update(newTagName);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestTagModel expected = RestTagModel.builder().id(tag.getId()).tag(newTagName).count(Integer.valueOf(0)).create();
        returnedModel.assertThat().isEqualTo((Object)expected, new String[0]);
    }
}

