/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.deployments;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestDeploymentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetDeploymentCoreTests
extends RestTest {
    private UserModel adminUser;
    private RestDeploymentModel expectedDeployment;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.REGRESSION}, description="Verify if get deployment request returns status code 404 when invalid deploymentId is used.")
    @Test(groups={"rest-api", "workflow", "deployments", "regression"})
    public void getNonNetworkDeploymentUsingInvalidDeploymentId() throws Exception {
        this.expectedDeployment = ((RestDeploymentModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getDeployments().getOneRandomEntry()).onModel();
        this.expectedDeployment.setId("invalidId");
        this.restClient.withWorkflowAPI().usingDeployment(this.expectedDeployment).getDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidId"));
    }
}

