/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessSanityTests
extends RestTest {
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel user;
    private RestProcessModel addedProcess;
    private RestProcessModel process;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.user = this.dataUser.createRandomTestUser();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.High);
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.SANITY}, description="Verify user is able to get the process started by him using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessByOwner() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessModel)this.process.assertThat().field("id").is((Object)this.addedProcess.getId())).and().field("startUserId").is((Object)this.addedProcess.getStartUserId());
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.SANITY}, description="Verify user is able to get the process assigned to him using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessByAssignee() throws Exception {
        this.process = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessModel)this.process.assertThat().field("id").is((Object)this.addedProcess.getId())).and().field("startUserId").is((Object)this.addedProcess.getStartUserId());
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.SANITY}, description="Verify admin is able to get any process using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessByAdmin() throws Exception {
        this.process = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessModel)this.process.assertThat().field("id").is((Object)this.addedProcess.getId())).and().field("startUserId").is((Object)this.addedProcess.getStartUserId());
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.SANITY}, description="Verify User that is not involved in a process cannot get that process using REST API and status code is FORBIDDEN (403)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void shouldNotGetProcessesByNotInvolvedUser() throws Exception {
        this.process = this.restClient.authenticateUser(this.user).withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).getProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }
}

