/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSitesMembershipInformationSanityTests
extends RestTest {
    private SiteModel siteModel;
    private UserModel adminUser;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to retrieve sites membership information of another user")
    public void siteManagerIsAbleToRetrieveSitesMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingUser(this.adminUser).getSitesMembershipInformation().assertThat().entriesListIsNotEmpty()).and().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site collaborator is able to retrieve sites membership information of another user")
    public void siteCollaboratorIsAbleToRetrieveSitesMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.adminUser).getSitesMembershipInformation().assertThat().entriesListIsNotEmpty()).and().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site contributor is able to retrieve sites membership information of another user")
    public void siteContributorIsAbleToRetrieveSitesMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(this.adminUser).getSitesMembershipInformation().assertThat().entriesListIsNotEmpty()).and().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site consumer is able to retrieve sites membership information of another user")
    public void siteConsumerIsAbleToRetrieveSitesMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.adminUser).getSitesMembershipInformation().assertThat().entriesListIsNotEmpty()).and().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify admin is able to retrieve sites membership information of another user")
    public void siteAdminIsAbleToRetrieveSitesMembershipInformation() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).getSitesMembershipInformation().assertThat().entriesListIsNotEmpty()).and().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify that unauthenticated user is not able to retrieve sites membership information")
    public void unauthenticatedUserCannotRetrieveSitesMembershipInformation() throws JsonToModelConversionException, Exception {
        UserModel inexistentUser = new UserModel("inexistent user", "wrong password");
        this.restClient.authenticateUser(inexistentUser).withCoreAPI().usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).getSitesMembershipInformation();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

