/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateTaskVariableTestsBulk3
extends RestTest {
    private SiteModel siteModel;
    private FileModel fileModel;
    private TaskModel taskModel;
    private UserModel userModel;
    private RestVariableModel taskVariable;
    private RestVariableModel updatedTaskVariable;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.userModel);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidVariableName() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"names\": \"varName\",\"value\": \"test\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"names\""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidVariableValue() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"name\": \"varName\",\"values\": \"test\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"values\""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithEmptyVariableName() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"\": \"varName\",\"value\": \"test\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"\""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with empty name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithEmptyName() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.taskVariable.setName("");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(RestErrorModel.PUT_EMPTY_ARGUMENT).containsSummary(RestErrorModel.PUT_EMPTY_ARGUMENT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with empty name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidName() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"name\": ',\"value\": \"test\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('''"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with empty name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidValue() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"name\": \"varName\",\"value\"::,\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unexpected character (':'"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with empty name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithMissingType() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"name\": \"varName\",\"value\": \"test\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)this.taskVariable.assertThat().field("scope").is((Object)this.taskVariable.getScope())).and().field("name").is((Object)this.taskVariable.getName())).and().field("type").is((Object)"d:text")).and().field("value").is(this.taskVariable.getValue());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with empty name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithMissingTypeAndValue() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"name\": \"varName\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.updatedTaskVariable = (RestVariableModel)this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestVariableModel)((RestVariableModel)this.updatedTaskVariable.assertThat().field("scope").is((Object)this.updatedTaskVariable.getScope())).and().field("name").is((Object)this.updatedTaskVariable.getName())).and().field("type").is((Object)"d:any");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithEmptyBody() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.VARIABLE_NAME_REQUIRED).containsSummary(RestErrorModel.VARIABLE_NAME_REQUIRED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidBody() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"name\": \"varName\",\"value\": \"test\",\"type\": \"d:text\", \"errorKey\": \"invalidBody\"}", (String)"tasks/{taskId}/variables/{variableName}", (String[])new String[]{this.taskModel.getId(), this.taskVariable.getName()});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"errorKey\""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with empty name - PUT call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTwiceInARowSameTaskVariable() throws Exception {
        this.taskVariable = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.taskVariable.setName("newName");
        this.taskVariable.setScope("global");
        this.updatedTaskVariable = this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.updatedTaskVariable.assertThat().field("scope").is((Object)"global");
        this.updatedTaskVariable.assertThat().field("name").is((Object)"newName");
        this.updatedTaskVariable = this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.taskVariable);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.updatedTaskVariable.assertThat().field("scope").is((Object)"global");
        this.updatedTaskVariable.assertThat().field("name").is((Object)"newName");
    }
}

