/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestNodeModelsCollection;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.model.RestRenditionInfoModelCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.RepoTestModel;
import org.springframework.http.HttpMethod;

public class Trashcan
extends ModelRequest<Trashcan> {
    public Trashcan(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public RestNodeModelsCollection findDeletedNodes() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "deleted-nodes?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNodeModelsCollection.class, request);
    }

    public RestNodeModel findDeletedNode(RepoTestModel repoModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "deleted-nodes/{nodeId}?{parameters}", repoModel.getNodeRefWithoutVersion(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public void deleteNodeFromTrashcan(RepoTestModel repoModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "deleted-nodes/{nodeId}", repoModel.getNodeRefWithoutVersion());
        this.restWrapper.processEmptyModel(request);
    }

    public RestNodeModel restoreNodeFromTrashcan(RepoTestModel repoModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "deleted-nodes/{nodeId}/restore?{parameters}", repoModel.getNodeRefWithoutVersion(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestResponse getDeletedNodeContent(RepoTestModel repoModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "deleted-nodes/{nodeId}/content?{parameters}", repoModel.getNodeRefWithoutVersion(), this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public RestRenditionInfoModelCollection getDeletedNodeRenditions(RepoTestModel repoModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "deleted-nodes/{nodeId}/renditions?{parameters}", repoModel.getNodeRefWithoutVersion(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestRenditionInfoModelCollection.class, request);
    }

    public RestRenditionInfoModel getDeletedNodeRendition(RepoTestModel repoModel, String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "deleted-nodes/{nodeId}/renditions/{renditionId}?{parameters}", repoModel.getNodeRefWithoutVersion(), renditionId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestRenditionInfoModel.class, request);
    }

    public RestResponse getDeletedNodeRenditionContent(RepoTestModel repoModel, String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "deleted-nodes/{nodeId}/renditions/{renditionId}/content?{parameters}", repoModel.getNodeRefWithoutVersion(), renditionId, this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }
}

