/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.containers;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteContainerModel;
import org.alfresco.rest.requests.Site;
import org.alfresco.utility.constants.ContainerName;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteContainerTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private SiteModel adminPrivateSiteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestSiteContainerModel siteContainerModel;
    private UserModel testUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.testUser)).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        this.adminPrivateSiteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.publicSiteModel)).createRandomLink();
        ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.adminPrivateSiteModel)).createRandomLink();
        ((DataLink)((DataLink)this.dataLink.usingUser(this.testUser)).usingSite(this.privateSiteModel)).createRandomLink();
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets site container and gets status code OK (200)")
    public void getSiteContainerWithManagerRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.siteContainerModel = (RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().getOneRandomEntry();
        ((RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(this.siteContainerModel.onModel()).assertThat().field("id").is((Object)this.siteContainerModel.onModel().getId())).and().field("folderId").is((Object)this.siteContainerModel.onModel().getFolderId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site container and gets status code OK (200)")
    public void getSiteContainerWithCollaboratorRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.siteContainerModel = (RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().getOneRandomEntry();
        ((RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(this.siteContainerModel.onModel()).and().field("id").is((Object)this.siteContainerModel.onModel().getId())).and().field("folderId").is((Object)this.siteContainerModel.onModel().getFolderId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets site container and gets status code OK (200)")
    public void getSiteContainerWithContributorRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.siteContainerModel = (RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().getOneRandomEntry();
        ((RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(this.siteContainerModel.onModel()).assertThat().field("id").is((Object)this.siteContainerModel.onModel().getId())).and().field("folderId").is((Object)this.siteContainerModel.onModel().getFolderId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets site container and gets status code OK (200)")
    public void getSiteContainerWithConsumerRole() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.siteContainerModel = (RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().getOneRandomEntry();
        ((RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(this.siteContainerModel.onModel()).assertThat().field("id").is((Object)this.siteContainerModel.onModel().getId())).and().field("folderId").is((Object)this.siteContainerModel.onModel().getFolderId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with admin user gets site container and gets status code OK (200)")
    public void getSiteContainerWithAdminUser() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.siteContainerModel = (RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().getOneRandomEntry();
        ((RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(this.siteContainerModel.onModel()).assertThat().field("id").is((Object)this.siteContainerModel.onModel().getId())).and().field("folderId").is((Object)this.siteContainerModel.onModel().getFolderId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site container call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSiteContainer() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.siteContainerModel = (RestSiteContainerModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().getOneRandomEntry();
        UserModel userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(this.siteContainerModel.onModel());
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get container request returns status code 400 when site doesn't exist")
    public void getContainerWithNonExistentSite() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite("NonExistentSiteId").getSiteContainer(ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, "NonExistentSiteId", ContainerName.links.toString()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get container request returns status code 400 when container item doesn't exist")
    public void getContainerWithNonExistentItem() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer("NonExistentFolder");
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.publicSiteModel.getId(), "NonExistentFolder"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user can get container for public site and request returns status 200")
    public void getContainerForPublicSite() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(ContainerName.links.toString()).assertThat().field("folderId").is((Object)ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify manager is able to get container for his private site and request returns status 200")
    public void getContainerForPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.privateSiteModel).getSiteContainer(ContainerName.links.toString()).assertThat().field("folderId").is((Object)ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get container request returns status 200 for moderated site")
    public void getContainerForModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.moderatedSiteModel).getSiteContainer(ContainerName.documentLibrary.toString()).assertThat().field("folderId").is((Object)ContainerName.documentLibrary.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get container request with properties parameter returns status code 200 and parameter is applied")
    public void getContainerUsingPropertiesParameter() throws Exception {
        ((RestSiteContainerModel)((RestSiteContainerModel)((Site)this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.publicSiteModel).usingParams(new String[]{"properties=id"})).getSiteContainer(ContainerName.links.toString()).assertThat().fieldsCount().is((Object)1)).and().field("id").isNotEmpty()).and().field("folderId").isNull();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get container request for a container that does not belong to site returns status code 404")
    public void getContainerThatDoesNotBelongToSite() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.moderatedSiteModel).getSiteContainer(ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.moderatedSiteModel.getId(), ContainerName.links.toString())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get container with name containing special chars returns status code 404")
    public void getContainerWithNameContainingSpecialChars() throws Exception {
        String containerSpecialName = RandomStringUtils.randomAlphabetic((int)2) + "~!%40%23%24%25%5E%26*()_%2B%5B%5D%7B%7D%7C%5C%3B%27%3A%22%2C.%2F%3C%3E";
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainer(containerSpecialName);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.publicSiteModel.getId(), containerSpecialName)).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if admin can get container request for a private site created by another user and status code is 200")
    public void adminCanGetContainerForPrivateSiteCreatedByUser() throws Exception {
        ((RestSiteContainerModel)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).getSiteContainer(ContainerName.links.toString()).assertThat().field("folderId").is((Object)ContainerName.links.toString())).and().field("id").isNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if user cannot get container request for a private site created by admin and status code is 404")
    public void userCannotGetContainerForPrivateSiteCreatedByAdmin() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.adminPrivateSiteModel).getSiteContainer(ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminPrivateSiteModel.getId(), ContainerName.links.toString())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get container request for a deleted container returns status code is 404")
    public void getContainerThatWasDeleted() throws Exception {
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.privateSiteModel).getSiteContainer(ContainerName.links.toString()).assertThat().field("folderId").is((Object)ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        FolderModel folder = new FolderModel("links");
        folder.setCmisLocation(String.format("/Sites/%s/%s", this.privateSiteModel.getId(), ContainerName.links.toString()));
        this.dataContent.deleteTree(folder);
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingSite(this.privateSiteModel).getSiteContainer(ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.privateSiteModel.getId(), ContainerName.links.toString())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

