/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateProcessVariableTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private RestProcessModel processModel;
    private RestProcessVariableModel variableModel;
    private RestProcessVariableModel updatedVariable;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Update existing variable using PUT call - invalid type")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void updateProcessVariableInvalidType() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setType("dd");
        this.updatedVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.UNSUPPORTED_TYPE, "dd")).containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "dd")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Update existing variable using PUT call - invalid type")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void updateProcessVariableTwoUsers() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:any");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setType("d:text");
        this.updatedVariable = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.updatedVariable.assertThat().field("type").is((Object)"d:text");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Update existing variable using PUT call - value")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void updateProcessVariableValue() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setValue("newValue");
        this.updatedVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.updatedVariable.assertThat().field("value").is((Object)"newValue");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Update existing variable using PUT call - name")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void updateProcessVariableName() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setName("newVariableName");
        this.updatedVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.updatedVariable.assertThat().field("name").is((Object)"newVariableName");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Update existing variable created by the user who started the process using put call with a user that is not involved in the process- value")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void cantUpdateProcessVariableValueCreatedWithAnyUser() throws Exception {
        UserModel anotherUser = this.dataUser.createRandomTestUser();
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setValue("newValue");
        this.restClient.authenticateUser(anotherUser).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Try to add process variable using an invalid processId")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void updateProcessVariableUsingInvalidProcessId() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.processModel.setId("abc");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "abc"));
    }
}

