/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessDefinitionModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionsSanityTests
extends RestTest {
    private UserModel adminUserModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.SANITY}, description="Verify Admin user gets process definitions for non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "sanity"})
    public void nonNetworkAdminGetsProcessDefinitions() throws Exception {
        RestProcessDefinitionModelsCollection processDefinitions = this.restClient.authenticateUser(this.adminUserModel).withWorkflowAPI().getAllProcessDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        processDefinitions.assertThat().entriesListIsNotEmpty();
        ((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)processDefinitions.getProcessDefinitionByDeploymentId("1").assertThat().field("name").is((Object)"Adhoc Activiti Process")).and().field("description").is((Object)"Assign a new task to yourself or a colleague")).and().field("id").is((Object)"activitiAdhoc:1:4")).and().field("startFormResourceKey").is((Object)"wf:submitAdhocTask")).and().field("category").is((Object)"http://alfresco.org")).and().field("title").is((Object)"New Task")).and().field("version").is((Object)"1")).and().field("graphicNotationDefined").is((Object)"true")).and().field("key").is((Object)"activitiAdhoc");
    }
}

