/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.swagger;

import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import org.alfresco.rest.core.swagger.Generator;
import org.alfresco.rest.core.swagger.SwaggerDefinitions;
import org.alfresco.rest.core.swagger.SwaggerPaths;
import org.alfresco.utility.exception.TestConfigurationException;

public class SwaggerYamlParser {
    private Swagger swagger;
    private String swaggerFilePath;

    public SwaggerYamlParser(String swaggerFilePath) throws TestConfigurationException {
        if (swaggerFilePath == null) {
            throw new TestConfigurationException("'swaggerFilePath' not defined. Please update your pom.xml file with all '<swagger-file-location.yml>'");
        }
        this.swaggerFilePath = swaggerFilePath;
        this.swagger = new SwaggerParser().read(this.swaggerFilePath);
    }

    public void computeCoverage() {
        new SwaggerPaths(this.swagger, this.swaggerFilePath).computeCoverage();
    }

    public void generateMissingModules() {
        String modelParamValue = System.getProperty("models");
        SwaggerDefinitions swaggerDefinitions = new SwaggerDefinitions(this.swagger);
        System.out.println(Generator.line);
        System.out.println("Using SWAGGER FILE: " + this.swaggerFilePath);
        System.out.println(Generator.line);
        if (modelParamValue.contains(",")) {
            String[] models = new String[]{};
            models = modelParamValue.split(",");
            for (int i = 0; i < models.length; ++i) {
                swaggerDefinitions.generateDefinition(models[i]);
            }
        } else if (modelParamValue.equals("true")) {
            swaggerDefinitions.generateMissingDefinitions();
        } else {
            swaggerDefinitions.generateDefinition(modelParamValue);
        }
    }
}

