/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.workflowAPI;

import io.restassured.RestAssured;
import jakarta.json.JsonObject;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestDeploymentModel;
import org.alfresco.rest.model.RestDeploymentModelsCollection;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessDefinitionModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.rest.requests.Deployments;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.requests.ProcessDefinitions;
import org.alfresco.rest.requests.Processes;
import org.alfresco.rest.requests.Task;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;

public class RestWorkflowAPI
extends ModelRequest<RestWorkflowAPI> {
    public RestWorkflowAPI(RestWrapper restWrapper) {
        super(restWrapper);
        RestAssured.basePath = "alfresco/api/-default-/public/workflow/versions/1";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public RestProcessModel addProcess(String processDefinitionKey, UserModel assignee, boolean sendEmailNotifications, CMISUtil.Priority priority) {
        return new Processes(this.restWrapper).addProcess(processDefinitionKey, assignee, sendEmailNotifications, priority);
    }

    public RestProcessModel addProcessWithBody(JsonObject postBody) {
        return new Processes(this.restWrapper).addProcessWithBody(postBody.toString());
    }

    public Task usingTask(TaskModel task) {
        return new Task(this.restWrapper, task);
    }

    public RestProcessModelsCollection getProcesses() {
        return new Processes(this.restWrapper).getProcesses();
    }

    public RestDeploymentModelsCollection getDeployments() {
        return new Deployments(this.restWrapper).getDeployments();
    }

    public Deployments usingDeployment(RestDeploymentModel deployment) {
        return new Deployments(deployment, this.restWrapper);
    }

    public RestProcessDefinitionModelsCollection getAllProcessDefinitions() {
        return new ProcessDefinitions(this.restWrapper).getAllProcessDefinitions();
    }

    public ProcessDefinitions usingProcessDefinitions(RestProcessDefinitionModel processDefinition) {
        return new ProcessDefinitions(processDefinition, this.restWrapper);
    }

    public Processes usingProcess(ProcessModel processModel) {
        return new Processes(processModel, this.restWrapper);
    }

    public RestTaskModelsCollection getTasks() {
        return new Task(this.restWrapper, null).getTasks();
    }
}

