/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.preferences;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPreferenceModelsCollection;
import org.alfresco.rest.requests.People;
import org.alfresco.utility.constants.PreferenceName;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeoplePreferencesFullTests
extends RestTest {
    UserModel userModel;
    UserModel user1;
    UserModel user2;
    UserModel adminUser;
    SiteModel siteModel;
    FolderModel folderModel;
    private RestPreferenceModelsCollection restPreferenceModelsCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.folderModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createFolder();
        this.user1 = this.dataUser.createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.user1)).usingSite(this.siteModel)).addSiteToFavorites();
        ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).addFolderToFavorites(this.folderModel);
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its preferences with skipCount parameter applied with Rest API and response is successful")
    public void userGetsItsPeoplePreferencesUsingSkipCountParameter() throws Exception {
        this.restPreferenceModelsCollection = ((People)this.restClient.authenticateUser(this.user1).withCoreAPI().usingMe().usingParams(new String[]{"skipCount=2"})).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restPreferenceModelsCollection.assertThat().paginationField("count").is("2");
        this.restPreferenceModelsCollection.assertThat().paginationField("skipCount").is("2");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListDoesNotContain("id", String.format(PreferenceName.EXT_FOLDERS_FAVORITES_PREFIX.toString(), "workspace://SpacesStore/" + this.folderModel.getNodeRef()))).and().entriesListDoesNotContain("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().entriesListContains("id", PreferenceName.FOLDERS_FAVORITES_PREFIX.toString())).and().entriesListContains("value", "workspace://SpacesStore/" + this.folderModel.getNodeRef())).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().entriesListContains("value", "true");
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its preferences with maxItems parameter applied with Rest API and response is successful")
    public void userGetsItsPeoplePreferencesUsingMaxItemsParameter() throws Exception {
        this.restPreferenceModelsCollection = ((People)this.restClient.authenticateUser(this.user1).withCoreAPI().usingMe().usingParams(new String[]{"maxItems=1"})).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restPreferenceModelsCollection.assertThat().paginationField("count").is("1");
        this.restPreferenceModelsCollection.assertThat().paginationField("maxItems").is("1");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", String.format(PreferenceName.EXT_FOLDERS_FAVORITES_PREFIX.toString(), "workspace://SpacesStore/" + this.folderModel.getNodeRef()))).and().entriesListDoesNotContain("id", String.format(PreferenceName.EXT_SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().entriesListDoesNotContain("id", PreferenceName.FOLDERS_FAVORITES_PREFIX.toString())).and().entriesListDoesNotContain("value", "workspace://SpacesStore/" + this.folderModel.getNodeRef())).and().entriesListDoesNotContain("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().entriesListDoesNotContain("value", "true");
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets admin preferences with Rest API and response is permission denied")
    public void userIsForbiddenToGetAdminPreferences() throws Exception {
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(this.user1).withCoreAPI().usingUser(this.adminUser).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its preferences with skipCount parameter higher then no of entries with Rest API and response is empty")
    public void userGetsItsPeoplePreferencesUsingHighSkipCount() throws Exception {
        this.restPreferenceModelsCollection = ((People)this.restClient.authenticateUser(this.user1).withCoreAPI().usingMe().usingParams(new String[]{"skipCount=100"})).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restPreferenceModelsCollection.assertThat().paginationField("count").is("0");
        this.restPreferenceModelsCollection.assertThat().paginationField("skipCount").is("100");
        this.restPreferenceModelsCollection.assertThat().entriesListIsEmpty();
    }

    @Bug(id="REPO-1911")
    @Test(groups={"rest-api", "people", "preferences", "regression"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get preferences for empty user with Rest API and response is 400")
    public void userGetsItsPeoplePreferencesForEmptyPersonId() throws Exception {
        UserModel emptyUserName = new UserModel("", "password");
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(this.user1).withCoreAPI().usingUser(emptyUserName).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(RestErrorModel.LOCAL_NAME_CONSISTANCE).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }
}

