/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.deployments;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestDeploymentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetDeploymentSanityTests
extends RestTest {
    private UserModel adminUser;
    private UserModel anotherUser;
    private RestDeploymentModel expectedDeployment;
    private RestDeploymentModel actualDeployment;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.expectedDeployment = ((RestDeploymentModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getDeployments().getOneRandomEntry()).onModel();
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets a non-network deployment using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "deployments", "sanity"})
    public void adminGetsNonNetworkDeploymentWithSuccess() throws JsonToModelConversionException, Exception {
        this.actualDeployment = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingDeployment(this.expectedDeployment).getDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestDeploymentModel)((RestDeploymentModel)this.actualDeployment.assertThat().field("deployedAt").isNotEmpty()).and().field("name").is((Object)this.expectedDeployment.getName())).and().field("id").is((Object)this.expectedDeployment.getId());
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.SANITY}, description="Verify non admin user is forbidden to get a non-network deployment using REST API (403)")
    @Test(groups={"rest-api", "workflow", "deployments", "sanity"})
    public void nonAdminIsForbiddenToGetNonNetworkDeployment() throws JsonToModelConversionException, Exception {
        this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().usingDeployment(this.expectedDeployment).getDeployment();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }
}

