/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.general;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.requests.Node;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.model.UserModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class MultipleResourcesCreator<RESOURCE extends TestModel, SELF extends MultiCreator<RESOURCE, ?>>
implements MultiCreator<RESOURCE, SELF> {
    protected UserModel user;
    protected List<String> names;
    protected List<String> aliases;

    protected abstract SELF self();

    @Override
    public SELF withNames(String ... names) {
        this.names = Stream.of(names).collect(Collectors.toList());
        return this.self();
    }

    public SELF withRandomNames(String ... prefixes) {
        this.aliases = Stream.of(prefixes).toList();
        return this.withNames((String[])Stream.of(prefixes).map(this::generateRandomNameWith).toArray(String[]::new));
    }

    public SELF withRandomNames(List<String> prefixes, List<String> suffixes) {
        this.aliases = prefixes;
        if (CollectionUtils.isEmpty(prefixes) || CollectionUtils.isEmpty(suffixes) || prefixes.size() != suffixes.size()) {
            throw new IllegalArgumentException("Provided suffixes size is different from prefixes size");
        }
        AtomicInteger i = new AtomicInteger();
        return this.withNames((String[])prefixes.stream().map(this::generateRandomNameWith).map(name -> name + (String)suffixes.get(i.getAndIncrement())).toArray(String[]::new));
    }

    public SELF withRandomNames(int namesCount) {
        return this.withNames((String[])IntStream.range(0, namesCount).mapToObj(i -> this.generateRandomName()).toArray(String[]::new));
    }

    @Override
    public <USER extends UserModel> SELF asUser(USER user) {
        this.user = user;
        return this.self();
    }

    protected String generateRandomName() {
        return this.generateRandomNameWith(RandomStringUtils.randomAlphanumeric((int)5) + "_");
    }

    protected String generateRandomNameWith(String prefix) {
        return this.generateRandomNameWith(prefix, "");
    }

    protected String generateRandomNameWith(String prefix, String suffix) {
        return prefix + String.valueOf(UUID.randomUUID()) + suffix;
    }

    protected Node buildNodeRestRequest(RestWrapper restClient, RepoTestModel node) {
        return restClient.authenticateUser(this.user).withCoreAPI().usingNode(node);
    }

    protected <T> T getOrNull(List<T> list, int index) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }
}

