/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.search;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'gethin' on '2017-03-01 14:46' from 'Alfresco Search REST API' swagger file Generated from 'Alfresco Search REST API' swagger file Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestResultSetContextModel extends TestModel implements IRestModel<RestResultSetContextModel>
{
    @JsonProperty(value = "entry")
    RestResultSetContextModel model;

    @Override
    public RestResultSetContextModel onModel()
    {
        return model;
    }

    private RestResponseConsistencyModel consistency;
    /**
     * The counts from facet queries
     */

    private List<FacetFieldBucket> facetQueries;
    /**
     * The counts from field facets
     */

    private List<RestResultBucketsModel> facetsFields;
    /**
     * The counts from facet intervals
     */

    private List<RestGenericFacetResponseModel> facets;
    /**
     * Suggested corrections
     * 
     * If zero results were found for the original query then a single entry of type "searchInsteadFor" will be returned. If alternatives were found that return more results than the original query they are returned as "didYouMean" options. The highest quality suggestion is first.
     * 
     */

    private SpellCheckModel spellCheck;

    private SearchRequest request;

    public RestResponseConsistencyModel getConsistency()
    {
        return this.consistency;
    }

    public void setConsistency(RestResponseConsistencyModel consistency)
    {
        this.consistency = consistency;
    }

    public List<FacetFieldBucket> getFacetQueries()
    {
        return this.facetQueries;
    }

    public void setFacetQueries(List<FacetFieldBucket> facetQueries)
    {
        this.facetQueries = facetQueries;
    }

    public List<RestResultBucketsModel> getFacetsFields()
    {
        return this.facetsFields;
    }

    public void setFacetsFields(List<RestResultBucketsModel> facetsFields)
    {
        this.facetsFields = facetsFields;
    }

    public List<RestGenericFacetResponseModel> getFacets()
    {
        return this.facets;
    }

    public void setFacets(List<RestGenericFacetResponseModel> facets)
    {
        this.facets = facets;
    }

    public SpellCheckModel getSpellCheck()
    {
        return this.spellCheck;
    }

    public void setSpellCheck(SpellCheckModel spellCheck)
    {
        this.spellCheck = spellCheck;
    }

    public SearchRequest getRequest()
    {
        return request;
    }

    public void setRequest(SearchRequest request)
    {
        this.request = request;
    }
}
