/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.category;

import java.util.Map;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.repo.resource.Categories;
import org.alfresco.rest.repo.resource.category.NestedCategoriesCreator;
import org.alfresco.rest.repo.resource.category.SerialCategoriesCreator;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.ResourceCreator;
import org.alfresco.rest.repo.resource.general.Specifier;

public class RepoCategoryCreator
extends ResourceCreator<RestCategoryModel, Creator.CategoryCreator>
implements Creator.CategoryCreator,
Specifier.CategoriesSpecifier {
    private final RestWrapper restClient;
    private RestCategoryModel parent = Categories.ROOT_CATEGORY;
    private final Map<String, RestCategoryModel> categoriesCache;

    public RepoCategoryCreator(RestWrapper restClient, Map<String, RestCategoryModel> categoriesCache) {
        this.restClient = restClient;
        this.categoriesCache = categoriesCache;
    }

    @Override
    protected Creator.CategoryCreator self() {
        return this;
    }

    @Override
    public Creator.CategoryCreator category(String name) {
        return (Creator.CategoryCreator)this.withName(name);
    }

    @Override
    public Creator.CategoryCreator randomCategory() {
        return (Creator.CategoryCreator)this.withRandomName();
    }

    @Override
    public Creator.CategoryCreator randomCategory(String prefix) {
        return this.withRandomName(prefix);
    }

    @Override
    public MultiCreator.CategoriesCreator categories(String ... names) {
        return (MultiCreator.CategoriesCreator)((MultiCreator.CategoriesCreator)new SerialCategoriesCreator(this.restClient, this.categoriesCache).withNames(names)).underCategory(this.parent).asUser(this.user);
    }

    @Override
    public MultiCreator.CategoriesCreator randomCategories(String ... prefixes) {
        return (MultiCreator.CategoriesCreator)((MultiCreator.CategoriesCreator)new SerialCategoriesCreator(this.restClient, this.categoriesCache).withRandomNames(prefixes)).underCategory(this.parent).asUser(this.user);
    }

    @Override
    public MultiCreator.CategoriesCreator randomCategories(int quantity) {
        return (MultiCreator.CategoriesCreator)((MultiCreator.CategoriesCreator)new SerialCategoriesCreator(this.restClient, this.categoriesCache).withRandomNames(quantity)).underCategory(this.parent).asUser(this.user);
    }

    @Override
    public MultiCreator.CategoriesCreator nestedCategories(String ... names) {
        return (MultiCreator.CategoriesCreator)((MultiCreator.CategoriesCreator)new NestedCategoriesCreator(this.restClient, this.categoriesCache).withNames(names)).underCategory(this.parent).asUser(this.user);
    }

    @Override
    public MultiCreator.CategoriesCreator nestedRandomCategories(String ... prefixes) {
        return (MultiCreator.CategoriesCreator)((MultiCreator.CategoriesCreator)new NestedCategoriesCreator(this.restClient, this.categoriesCache).withRandomNames(prefixes)).underCategory(this.parent).asUser(this.user);
    }

    @Override
    public MultiCreator.CategoriesCreator nestedRandomCategories(int depth) {
        return (MultiCreator.CategoriesCreator)((MultiCreator.CategoriesCreator)new NestedCategoriesCreator(this.restClient, this.categoriesCache).withRandomNames(depth)).underCategory(this.parent).asUser(this.user);
    }

    @Override
    public Creator.CategoryCreator withRandomName(String prefix) {
        this.withAlias(prefix);
        return (Creator.CategoryCreator)super.withRandomName(prefix);
    }

    public Creator.CategoryCreator underCategory(RestCategoryModel parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public RestCategoryModel create() {
        RestCategoryModel category = this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(this.parent).createSingleCategory(RestCategoryModel.builder().name(this.name).create());
        this.categoriesCache.put(this.alias, category);
        return category;
    }

    @Override
    protected String generateRandomName() {
        return this.generateRandomNameWith("");
    }

    @Override
    protected String generateRandomNameWith(String prefix) {
        return super.generateRandomNameWith("category" + prefix + "_");
    }
}

