/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCustomTypeModel;
import org.alfresco.rest.requests.CustomModelProperties;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.CustomAspectPropertiesModel;
import org.alfresco.utility.model.CustomContentModel;
import org.springframework.http.HttpMethod;

public class CustomTypeManager
extends ModelRequest<CustomTypeManager> {
    private CustomContentModel customContentModel;
    private RestCustomTypeModel customTypeModel;
    private CustomModelProperties customProperties;

    public CustomTypeManager(CustomContentModel customContentModel, RestCustomTypeModel customTypeModel, RestWrapper restWrapper) {
        super(restWrapper);
        this.customProperties = new CustomModelProperties(this.restWrapper);
        this.customContentModel = customContentModel;
        this.customTypeModel = customTypeModel;
    }

    public RestCustomTypeModel getCustomType() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "cmm/{modelName}/types/{typeName}?{parameters}", this.customContentModel.getName(), this.customTypeModel.getName(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestCustomTypeModel.class, request);
    }

    public void addProperty(CustomAspectPropertiesModel propertyModel) {
        this.customProperties.addProperty(propertyModel, this.customContentModel, false, this.customTypeModel.getName(), false, null);
    }

    public void addPropertyWithMinMaxValueConstraint(CustomAspectPropertiesModel propertyModel, int minValue, int maxValue) {
        this.customProperties.addProperty(propertyModel, this.customContentModel, false, this.customTypeModel.getName(), true, this.customProperties.createMinMaxValueConstraintArray(minValue, maxValue));
    }

    public void addPropertyWithMinMaxLengthConstraint(CustomAspectPropertiesModel propertyModel, int minLength, int maxLength) {
        this.customProperties.addProperty(propertyModel, this.customContentModel, false, this.customTypeModel.getName(), true, this.customProperties.createMinMaxLengthConstraint(minLength, maxLength));
    }

    public void addPropertyWithListOfValues(CustomAspectPropertiesModel propertyModel, boolean sorted, String ... listOfValues) {
        this.customProperties.addProperty(propertyModel, this.customContentModel, false, this.customTypeModel.getName(), true, this.customProperties.createListOfValuesConstraint(sorted, listOfValues));
    }

    public void deleteCustomType() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "cmm/{modelName}/types/{typeName}", this.customContentModel.getName(), this.customTypeModel.getName());
        this.restWrapper.processEmptyModel(request);
    }
}

