/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteSiteMemberCoreTests
extends RestTest {
    private UserModel userModel;
    private UserModel managerModel;
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private UserModel adminUserModel;
    private UserModel secondUserModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.secondUserModel = this.dataUser.createRandomTestUser();
        this.secondUserModel.setUserRole(UserRole.SiteCollaborator);
        this.userModel = this.dataUser.createRandomTestUser();
        this.userModel.setUserRole(UserRole.SiteCollaborator);
        this.managerModel = this.dataUser.createRandomTestUser();
        this.managerModel.setUserRole(UserRole.SiteManager);
        this.adminUserModel = this.dataUser.getAdminUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPrivateRandomSite();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user removes a site member using '-me-' in place of personId and response is successful (204)")
    public void removeSiteMemberWithSuccessUsingMeAsPersonId() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user can't remove a site membership of an inexistent uer and response is 404")
    public void userIsNotAbleToRemoveInexistentSiteMember() throws Exception {
        UserModel inexistentUser = new UserModel("inexistenUser", "password");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(inexistentUser).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentUser.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a member of an inexistent site and response is 404")
    public void userIsNotAbleToRemoveMembershipOfInexistentSite() throws Exception {
        SiteModel inexistentSite = new SiteModel("inexistentSite");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.userModel).deleteSiteMember(inexistentSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.userModel.getUsername(), inexistentSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a member of an empty site id and response is 404")
    public void userIsNotAbleToRemoveMembershipOfEmptySiteId() throws Exception {
        SiteModel inexistentSite = new SiteModel("");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.userModel).deleteSiteMember(inexistentSite);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.DELETE_EMPTY_ARGUMENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a regular member a moderated site and response is 422")
    public void regularUserIsNotAbleToRemoveRegularUserSiteMembershipFromModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.secondUserModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.secondUserModel).withCoreAPI().usingUser(this.userModel).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a regular member of a private site and response is 422")
    public void regularUserIsNotAbleToRemoveRegularUserSiteMembershipFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.secondUserModel);
        this.restClient.authenticateUser(this.secondUserModel).withCoreAPI().usingUser(this.userModel).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.privateSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove a regular member of a moderated site and response is 204")
    public void adminIsAbleToRemoveRegularUserSiteMembershipFromModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.userModel).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove a regular member of a private site and response is 204")
    public void adminIsAbleToRemoveRegularUserSiteMembershipFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.userModel).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove admin membership from public site and response is 422")
    public void regularUserIsNotAbleToRemoveAdminSiteMembershipFromPublicSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.managerModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove admin membership from moderated site and response is 422")
    public void regularUserIsNotAbleToRemoveAdminSiteMembershipFromModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(this.managerModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove admin membership from private site and response is 422")
    public void regularUserIsNotAbleToRemoveAdminSiteMembershipFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.managerModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.userModel);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.privateSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove the membership of a manager from a public site and response is 204")
    public void adminIsAbleToRemoveManagerSiteMembershipOfPublicSite() throws Exception {
        UserModel secondManager = this.dataUser.createRandomTestUser();
        secondManager.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(secondManager);
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.managerModel);
        this.restClient.withCoreAPI().usingUser(this.managerModel).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove the membership of a manager from a moderated site and response is 204")
    public void adminIsAbleToRemoveManagerSiteMembershipOfModeratedSite() throws Exception {
        UserModel secondManager = this.dataUser.createRandomTestUser();
        secondManager.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(secondManager);
        this.restClient.withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(this.managerModel);
        this.restClient.withCoreAPI().usingUser(this.managerModel).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to remove the membership of a manager from a private site and response is 204")
    public void adminIsAbleToRemoveManagerSiteMembershipOfPrivateSite() throws Exception {
        UserModel secondManager = this.dataUser.createRandomTestUser();
        secondManager.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(secondManager);
        this.restClient.withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.managerModel);
        this.restClient.withCoreAPI().usingUser(this.managerModel).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator is not able to remove the membership of a manager from a public site and response is 204")
    public void userIsNotAbleToRemoveManagerSiteMembershipOfPublicSite() throws Exception {
        UserModel secondManager = this.dataUser.createRandomTestUser();
        secondManager.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(secondManager);
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.userModel);
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.managerModel);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.managerModel).deleteSiteMember(this.publicSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator is not able to remove the membership of a manager from a moderated site and response is 204")
    public void userIsNotAbleToRemoveManagerSiteMembershipOfModeratedSite() throws Exception {
        UserModel secondManager = this.dataUser.createRandomTestUser();
        secondManager.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(secondManager);
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addPerson(this.userModel);
        this.restClient.withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(this.managerModel);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.managerModel).deleteSiteMember(this.moderatedSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator is not able to remove the membership of a manager from a private site and response is 204")
    public void userIsNotAbleToRemoveManagerSiteMembershipOfPrivateSite() throws Exception {
        UserModel secondManager = this.dataUser.createRandomTestUser();
        secondManager.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(secondManager);
        this.restClient.withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.userModel);
        this.restClient.withCoreAPI().usingSite(this.privateSiteModel).addPerson(this.managerModel);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.managerModel).deleteSiteMember(this.privateSiteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.privateSiteModel.getId()));
    }
}

