/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateTaskVariableTestsBulk1
extends RestTest {
    private UserModel userModel;
    private UserModel adminUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private UserModel assigneeUser;
    private TaskModel taskModel;
    private RestVariableModel taskVariable;
    private RestVariableModel variableModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Create non-existing task variable")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void createTaskVariable() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)this.taskVariable.assertThat().field("scope").is((Object)this.taskVariable.getScope())).and().field("name").is((Object)this.taskVariable.getName())).and().field("type").is((Object)this.taskVariable.getType())).and().field("value").is(this.taskVariable.getValue());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Update existing task variable")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void updateExistingTaskVariable() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)this.taskVariable.assertThat().field("scope").is((Object)this.taskVariable.getScope())).and().field("name").is((Object)this.taskVariable.getName())).and().field("type").is((Object)this.taskVariable.getType())).and().field("value").is(this.taskVariable.getValue());
        this.variableModel.setValue((Object)"updatedValue");
        this.taskVariable = this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskVariable.assertThat().field("value").is((Object)"updatedValue");
    }
}

