/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.renditions;

import java.io.File;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.model.RestRenditionInfoModelCollection;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"renditions"})
public class RenditionVersionTests
extends RestTest {
    private UserModel user;
    private SiteModel site;
    private FileModel file;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        this.file = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @Test(groups={"rest-api", "renditions", "sanity"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify that the rendition  can be created using POST /nodes/{nodeId}/versions/{versionId}/rendition")
    public void testRenditionForNodeVersions() throws Exception {
        File sampleFile = Utility.getResourceTestDataFile((String)"sampleContent.txt");
        Step.STEP((String)"1. Update the node content in order to increase version, PUT /nodes/{nodeId}/content.");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file).updateNodeContent(sampleFile);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"2. Create the pdf rendition of txt file using RESTAPI");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file).createNodeVersionRendition("pdf", "1.1");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Step.STEP((String)"3. Verify pdf rendition of txt file is created");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file).getNodeVersionRenditionUntilIsCreated("pdf", "1.1").assertThat().field("status").is((Object)"CREATED");
        Step.STEP((String)"4. Verify pdf rendition of txt file is listed");
        RestRenditionInfoModelCollection renditionInfoModelCollection = this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file).getNodeVersionRenditionsInfo("1.1");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        for (RestRenditionInfoModel restRenditionInfoModel : renditionInfoModelCollection.getEntries()) {
            RestRenditionInfoModel renditionInfo = restRenditionInfoModel.onModel();
            String renditionId = renditionInfo.getId();
            if (renditionId != "pdf") continue;
            renditionInfo.assertThat().field("status").is((Object)"CREATED");
        }
        Step.STEP((String)"5. Verify pdf rendition of txt file has content");
        RestResponse restResponse = this.restClient.withCoreAPI().usingNode((RepoTestModel)this.file).getNodeVersionRenditionContentUntilIsCreated("pdf", "1.1");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Type", "application/pdf;charset=UTF-8");
        Assert.assertTrue((restResponse.getResponse().body().asInputStream().available() > 0 ? 1 : 0) != 0);
    }
}

