/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.deployments;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestDeploymentModel;
import org.alfresco.rest.model.RestDeploymentModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetDeploymentsSanityTests
extends RestTest {
    private UserModel adminUserModel;
    private RestDeploymentModelsCollection deployments;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
    }

    @TestRail(section={"rest-api", "workflow", "deployments"}, executionType={ExecutionType.SANITY}, description="Verify Admin user gets non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "deployments", "sanity"})
    public void getNonNetworkDeploymentsWithAdmin() throws JsonToModelConversionException, Exception {
        this.deployments = this.restClient.authenticateUser(this.adminUserModel).withWorkflowAPI().getDeployments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.deployments.assertThat().entriesListIsNotEmpty();
        ((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)((RestDeploymentModel)this.deployments.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)4)).and().field("id").isNotEmpty()).and().field("deployedAt").isNotEmpty()).and().field("name").isNotEmpty()).and().field("category").isNotEmpty();
    }
}

