/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetFavoriteSitesTests
extends RestTest {
    private UserModel userModel;
    private UserModel testUser1;
    private SiteModel siteModel;
    private SiteModel testSite1;
    private SiteModel testSite2;
    private SiteModel testSite3;
    private RestSiteModelsCollection restSiteModelsCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.testSite1 = new SiteModel("A-" + RandomData.getRandomAlphanumeric());
        this.testSite2 = new SiteModel("B-" + RandomData.getRandomAlphanumeric());
        this.testSite3 = new SiteModel("C-" + RandomData.getRandomAlphanumeric());
        ((DataSite)((DataSite)this.dataSite.usingUser(this.userModel)).usingSite(this.siteModel)).addSiteToFavorites();
        ((DataSite)this.dataSite.usingUser(this.testUser1)).createSite(this.testSite1);
        ((DataSite)this.dataSite.usingUser(this.testUser1)).createSite(this.testSite2);
        ((DataSite)this.dataSite.usingUser(this.testUser1)).createSite(this.testSite3);
        ((DataSite)((DataSite)this.dataSite.usingUser(this.testUser1)).usingSite(this.testSite3)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.testUser1)).usingSite(this.testSite2)).addSiteToFavorites();
        ((DataSite)((DataSite)this.dataSite.usingUser(this.testUser1)).usingSite(this.testSite1)).addSiteToFavorites();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager user fails to get an user favorite sites with Rest API (403)")
    public void managerUserFailsToGetAnUserFavoriteSites() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        UserModel anotherUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(anotherUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingUser(anotherUser).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user fails to get an user favorite sites with Rest API (403)")
    public void collaboratorUserFailsToGetAnUserFavoriteSites() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(collaboratorUser, this.siteModel, UserRole.SiteCollaborator);
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser, this.siteModel, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingUser(contributorUser).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user fails to get an user favorite sites with Rest API (403)")
    public void contributorUserFailsToGetAnUserFavoriteSites() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        UserModel contributorUser2 = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser, this.siteModel, UserRole.SiteContributor);
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser2, this.siteModel, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser2)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restClient.authenticateUser(contributorUser).withCoreAPI().usingUser(contributorUser2).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user fails to get an user favorite sites with Rest API (403)")
    public void consumerUserFailsToGetAnUserFavoriteSites() throws Exception {
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, this.siteModel, UserRole.SiteConsumer);
        ((DataUser)this.dataUser.usingUser(collaboratorUser)).addUserToSite(collaboratorUser, this.siteModel, UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restClient.authenticateUser(consumerUser).withCoreAPI().usingUser(collaboratorUser).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify any user gets its own user favorite sites with Rest API and response is successful (200)")
    public void anyUserGetsHisFavoriteSites() throws Exception {
        UserModel anyUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(anyUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restSiteModelsCollection = this.restClient.authenticateUser(anyUser).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restSiteModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.siteModel.getId())).and().paginationExist();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify any user is NOT Authorized to get its favorite sites with Rest API when authentication fails (401)")
    public void unauthenticatedUserIsNotAuthorizedToGetFavoriteSites() throws Exception {
        UserModel anyUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(anyUser)).usingSite(this.siteModel)).addSiteToFavorites();
        anyUser.setPassword("newpassword");
        this.restClient.authenticateUser(anyUser).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request status code is 404 for a personId that does not exist")
    @Test(groups={"rest-api", "people", "regression"})
    public void getFavoriteSitesReturns404ForAPersonIdThatDoesNotExist() throws Exception {
        UserModel invalidUser = new UserModel(RandomData.getRandomName((String)"User"), DataUser.PASSWORD);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(invalidUser).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, invalidUser.getUsername())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request status code is 403 if the user doesn't have access to the person favorite sites")
    @Test(groups={"rest-api", "people", "regression"})
    public void userCannotGetFavoriteSitesForAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.testUser1).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin has access to regular user site favorites")
    @Test(groups={"rest-api", "people", "regression"})
    public void adminCanGetFavoriteSitesForARegularUser() throws Exception {
        this.restSiteModelsCollection = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(this.userModel).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.restSiteModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.siteModel.getId());
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that regular user can not see admin user site favorites")
    @Test(groups={"rest-api", "people", "regression"})
    public void regularUserCannotGetFavoriteSitesForAdminUser() throws Exception {
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingUser(this.dataUser.getAdminUser()).getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that favorite site can be removed")
    @Test(groups={"rest-api", "people", "regression"})
    public void verifyThatFavoriteSiteCanBeRemoved() throws Exception {
        UserModel randomTestUser = this.dataUser.createRandomTestUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(randomTestUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restSiteModelsCollection = this.restClient.authenticateUser(randomTestUser).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.restSiteModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.siteModel.getId());
        ((DataSite)((DataSite)this.dataSite.usingUser(randomTestUser)).usingSite(this.siteModel)).removeSiteFromFavorites();
        this.restSiteModelsCollection = this.restClient.withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restSiteModelsCollection.assertThat().entriesListIsEmpty();
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that if maxItems param is invalid status code returned is BAD_REQUEST (400)")
    @Test(groups={"rest-api", "people", "regression"})
    public void getFavoriteSitesMaxItemsInvalidValueTest() throws Exception {
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"maxItems=-1"}).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"maxItems=abc"}).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "abc"));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that if skipCount param is invalid status code returned is BAD_REQUEST (400)")
    @Test(groups={"rest-api", "people", "regression"})
    public void getFavoriteSitesSkipCountInvalidValueTest() throws Exception {
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT);
        this.restClient.authenticateUser(this.userModel).withParams(new String[]{"skipCount=abc"}).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "abc"));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request response status using -me- string in place of personId is OK (200)")
    @Test(groups={"rest-api", "people", "regression"})
    public void userGetsFavoriteSiteWithSuccessUsingMEForRequest() throws Exception {
        this.restSiteModelsCollection = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingMe().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restSiteModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.testSite1.getId())).and().paginationExist();
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request response status for a user that has no favorite sites is OK (200)")
    @Test(groups={"rest-api", "people", "regression"})
    public void getFavoriteSiteRequestForUserWithNoFavoriteSitesIsSuccessful() throws Exception {
        UserModel randomTestUser = this.dataUser.createRandomTestUser();
        this.restSiteModelsCollection = this.restClient.authenticateUser(randomTestUser).withCoreAPI().usingMe().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restSiteModelsCollection.assertThat().entriesListIsEmpty();
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request response status for a user with several favorite sites is OK (200)")
    @Test(groups={"rest-api", "people", "regression"})
    public void getFavoriteSiteRequestForUserWithSeveralFavoriteSitesIsSuccessful() throws Exception {
        this.restSiteModelsCollection = this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restSiteModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.testSite1.getId())).and().entriesListContains("id", this.testSite2.getId())).and().entriesListContains("id", this.testSite3.getId())).and().paginationExist();
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request can only be called with a positive maxItems param")
    @Test(groups={"rest-api", "people", "regression"})
    public void userCanNotGetFavoriteSitesWith0MaxItems() throws Exception {
        this.restClient.authenticateUser(this.testUser1).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request response status code for a high skipCount param is OK (200)")
    @Test(groups={"rest-api", "people", "regression"})
    public void userCanGetFavoriteSitesWithHighSkipCount() throws Exception {
        this.restSiteModelsCollection = this.restClient.authenticateUser(this.testUser1).withParams(new String[]{"skipCount=999999999"}).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.restSiteModelsCollection.assertThat().entriesListIsEmpty()).assertThat().paginationField("skipCount").is("999999999");
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can retrieve the last 2 favorite sites")
    @Test(groups={"rest-api", "people", "regression"})
    public void userCanRetrieveLast2FavoriteSites() throws Exception {
        this.restSiteModelsCollection = this.restClient.authenticateUser(this.testUser1).withParams(new String[]{"skipCount=1&maxCount=2"}).withCoreAPI().usingAuthUser().getFavoriteSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)this.restSiteModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().entriesListCountIs(2)).assertThat().entriesListContains("id", this.testSite2.getId())).assertThat().entriesListContains("id", this.testSite3.getId());
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request applies valid properties param")
    @Test(groups={"rest-api", "people", "regression"})
    public void getFavoriteSitesRequestWithValidPropertiesParam() throws Exception {
        RestSiteModel restSiteModel = ((RestSiteModel)this.restClient.authenticateUser(this.testUser1).withParams(new String[]{"properties=title"}).withCoreAPI().usingAuthUser().getFavoriteSites().getOneRandomEntry()).onModel();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)restSiteModel.assertThat().fieldsCount().is((Object)1)).assertThat().field("title").isNotEmpty();
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request applies invalid properties param")
    @Test(groups={"rest-api", "people", "regression"})
    public void getFavoriteSitesRequestWithInvalidPropertiesParam() throws Exception {
        ((RestSiteModel)this.restClient.authenticateUser(this.testUser1).withParams(new String[]{"properties=tas"}).withCoreAPI().usingAuthUser().getFavoriteSites().getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)0);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

