/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.groups;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RemoveSiteGroupTests
extends RestTest {
    private SiteModel publicSiteModel;
    private SiteModel privateSiteModel;
    private UserModel adminUserModel;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUserModel = this.dataUser.getAdminUser();
        UserModel siteCreator = this.dataUser.createRandomTestUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(siteCreator)).createPublicRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(siteCreator)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.addGroupToSite(this.publicSiteModel, UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify manager can delete site group and gets status code 204, 'No Content'")
    public void siteManagerIsAbleToDeleteSiteGroup() throws Exception {
        GroupModel group = this.addGroupToSite(this.publicSiteModel, UserRole.SiteConsumer).get(0);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroups().assertThat().entriesListDoesNotContain("id", this.getId(group)));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator cannot delete site group and gets status code 403, 'Forbidden'")
    public void siteCollaboratorIsNotAbleToDeleteSiteGroup() throws Exception {
        GroupModel group = this.addGroupToSite(this.publicSiteModel, UserRole.SiteConsumer).get(0);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroups().assertThat().entriesListContains("id", this.getId(group)));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor cannot delete site group and gets status code 403, 'Forbidden'")
    public void siteContributorIsNotAbleToDeleteSiteGroup() throws Exception {
        GroupModel group = this.addGroupToSite(this.publicSiteModel, UserRole.SiteConsumer).get(0);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroups().assertThat().entriesListContains("id", this.getId(group)));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer cannot delete site member and gets status code 403, 'Forbidden'")
    public void siteConsumerIsNotAbleToDeleteSiteGroup() throws Exception {
        GroupModel group = this.addGroupToSite(this.publicSiteModel, UserRole.SiteConsumer).get(0);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteGroups().assertThat().entriesListContains("id", this.getId(group)));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that unauthenticated user is not able to delete site group")
    public void unauthenticatedUserIsNotAuthorizedToDeleteSiteGroup() throws Exception {
        GroupModel group = this.addGroupToSite(this.publicSiteModel, UserRole.SiteConsumer).get(0);
        UserModel inexistentUser = new UserModel("inexistent user", "inexistent password");
        this.restClient.authenticateUser(inexistentUser).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify manager can NOT delete site group for an inexistent user and gets status code 404, 'Not Found'")
    @Test(groups={"rest-api", "sites", "regression"})
    public void managerIsNotAbleToDeleteInexistentSiteGroup() throws Exception {
        GroupModel inexistentUser = new GroupModel("inexistentUser");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(inexistentUser));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("An authority was not found for %s", this.getId(inexistentUser)));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify manager can NOT delete site group for a non site group and gets status code 400, 'Bad Request'")
    @Test(groups={"rest-api", "sites", "regression"})
    public void managerIsNotAbleToDeleteNotSiteGroup() throws Exception {
        GroupModel nonMember = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(nonMember));
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format("Given authority is not a member of the site", new Object[0]));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can NOT delete site group for an invalid site and gets status code 404, 'Not Found'")
    @Test(groups={"rest-api", "sites", "regression"})
    public void managerIsNotAbleToDeleteSiteMemberOfInvalidSite() throws Exception {
        SiteModel invalidSite = new SiteModel("invalidSite");
        GroupModel testGroupModel = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(invalidSite).deleteSiteGroup(this.getId(testGroupModel));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, "invalidSite"));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can delete a site group of private site and gets status code 204")
    @Test(groups={"rest-api", "sites", "regression"})
    public void adminIsAbleToDeletePrivateSiteGroup() throws Exception {
        GroupModel group = this.addGroupToSite(this.privateSiteModel, UserRole.SiteConsumer).get(0);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can not delete a site group twice and gets status code 404 for the second attempt")
    @Test(groups={"rest-api", "sites", "regression"})
    @Bug(id="ACE-5447")
    public void adminIsNotAbleToRemoveSiteGroupTwice() throws Exception {
        GroupModel group = this.addGroupToSite(this.publicSiteModel, UserRole.SiteContributor).get(0);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteGroup(this.getId(group));
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Given authority is not a member of the site");
    }

    List<GroupModel> addGroupToSite(SiteModel siteModel, UserRole ... roles) {
        ArrayList<GroupModel> groups = new ArrayList<GroupModel>();
        for (UserRole role : roles) {
            GroupModel group = this.dataGroup.createRandomGroup();
            this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(siteModel).addSiteGroup(this.getId(group), role);
            groups.add(group);
        }
        return groups;
    }

    String getId(GroupModel group) {
        return "GROUP_" + group.getGroupIdentifier();
    }
}

