/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.assertion;

import org.alfresco.rest.core.IRestModelsCollection;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.utility.exception.TestConfigurationException;
import org.apache.commons.beanutils.BeanUtils;
import org.testng.Assert;

public class PaginationAssertionVerbs<C> {
    private RestPaginationModel pagination;
    private C modelCollection;
    private String fieldName;

    public PaginationAssertionVerbs(IRestModelsCollection modelCollection, String fieldName, RestPaginationModel pagination) {
        this.modelCollection = modelCollection;
        this.fieldName = fieldName;
        this.pagination = pagination;
    }

    private String getFieldValue() {
        String value = "";
        try {
            value = BeanUtils.getProperty((Object)this.pagination, (String)this.fieldName);
        }
        catch (Exception e) {
            throw new TestConfigurationException(String.format("You try to assert field [%s] that doesn't exist in class: [%s]. Exception: %s, Please check your code!", this.fieldName, this.modelCollection.getClass().getCanonicalName(), e.getMessage()));
        }
        return value;
    }

    private String errorMessage(String info) {
        return String.format("The value of field [%s -> from %s] %s", this.fieldName, this.modelCollection.getClass().getCanonicalName(), info);
    }

    public C is(String expected) {
        Assert.assertEquals((String)this.getFieldValue(), (String)expected, (String)this.errorMessage("is NOT correct,"));
        return this.modelCollection;
    }

    public C isNot(Object expected) {
        Assert.assertNotEquals((Object)this.getFieldValue(), (Object)expected, (String)this.errorMessage("is correct,"));
        return this.modelCollection;
    }

    public C isNotEmpty() {
        Assert.assertNotEquals((Object)this.getFieldValue(), (Object)"", (String)this.errorMessage("is empty,"));
        return this.modelCollection;
    }

    public C isNotNull() {
        Assert.assertNotNull((Object)this.getFieldValue(), (String)this.errorMessage("is null,"));
        return this.modelCollection;
    }

    public C isNotPresent() {
        Assert.assertNull((Object)this.getFieldValue(), (String)this.errorMessage("is present,"));
        return this.modelCollection;
    }

    public C isEmpty() {
        Assert.assertEquals((String)this.getFieldValue(), (String)"", (String)this.errorMessage("is NOT empty,"));
        return this.modelCollection;
    }
}

