/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessesSanityTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private UserModel anotherUser;
    private TaskModel task;
    private RestProcessModelsCollection allProcesses;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.task = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify User gets all processes started by him using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessesByUserWhoStartedProcess() throws Exception {
        this.allProcesses = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.allProcesses.assertThat().entriesListContains("id", this.task.getProcessId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify User gets all processes assigned to him using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessesByAssignedUser() throws Exception {
        this.allProcesses = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.allProcesses.assertThat().entriesListContains("id", this.task.getProcessId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify User that is not involved in a process can not get that process using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessesByAnotherUser() throws Exception {
        this.allProcesses = this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.allProcesses.assertThat().entriesListDoesNotContain("id", this.task.getProcessId());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify Admin gets all processes, even if he isn't involved in a process, using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessesByAdmin() throws Exception {
        this.allProcesses = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.allProcesses.assertThat().entriesListContains("id", this.task.getProcessId());
    }
}

