/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.renditions;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"renditions"})
public class CreateRenditionTests
extends RestTest {
    private UserModel adminUser;
    private UserModel user;
    private SiteModel site;
    private FileModel document;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @BeforeMethod(alwaysRun=true)
    public void createDocument() throws Exception {
        this.document = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @Bug(id="REPO-2042", description="Should fail only on MAC OS System and Linux", status=Bug.Status.FIXED)
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify admin user creates rendition with Rest API and status code is 202")
    @Test(groups={"rest-api", "renditions", "sanity"})
    public void adminCanCreateRenditionToExistingNode() throws JsonToModelConversionException, Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.document).createNodeRendition("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.document).getNodeRenditionUntilIsCreated("pdf").assertThat().field("status").is((Object)"CREATED");
    }

    @Bug(id="REPO-2042", description="Should fail only on MAC OS System and Linux", status=Bug.Status.FIXED)
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.REGRESSION}, description="Verify user that created the document can also creates 'pdf' rendition for it with Rest API and status code is 202")
    @Test(groups={"rest-api", "renditions", "regression"})
    public void userThatCreatedFileCanCreatePdfRenditionForIt() throws JsonToModelConversionException, Exception {
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.document).createNodeRendition("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.document).getNodeRenditionUntilIsCreated("pdf").assertThat().field("status").is((Object)"CREATED");
    }

    @Bug(id="REPO-2042", description="Should fail only on MAC OS System and Linux", status=Bug.Status.FIXED)
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.REGRESSION}, description="Verify user that created the document can also creates 'doclib' rendition for it with Rest API and status code is 202")
    @Test(groups={"rest-api", "renditions", "regression", "not-supported-by-ats"})
    public void userThatCreatedFileCanCreateDoclibRenditionForIt() throws JsonToModelConversionException, Exception {
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        this.restClient.authenticateUser(this.user).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"my-file.tif"));
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingResource((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.document = new FileModel("my-file.tif");
        this.document.setCmisLocation(folder.getCmisLocation() + "/my-file.tif");
        this.document.setNodeRef(fileNode.getId());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.document).createNodeRendition("doclib");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Utility.sleep((int)500, (int)60000, () -> this.restClient.withCoreAPI().usingNode((RepoTestModel)this.document).getNodeRenditionUntilIsCreated("doclib").assertThat().field("status").is((Object)"CREATED"));
    }
}

