/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.models.aspects;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestAbstractClassModel;
import org.alfresco.rest.model.RestAspectsCollection;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.requests.modelAPI.RestModelAPI;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetAspectsTests
extends RestTest {
    private UserModel regularUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify user get aspects and gets status code OK (200)")
    public void getAspects() throws Exception {
        RestAspectsCollection aspects = this.restClient.authenticateUser(this.regularUser).withModelAPI().getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)aspects.assertThat().entriesListCountIs(100)).and().entriesListContains("id", "cm:classifiable")).and().entriesListContains("id", "cm:author")).and().entriesListContains("id", "cm:checkedOut");
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter aspects using namespace uri and gets status code OK (200)")
    public void getAspectByNamespaceUri() throws Exception {
        RestAspectsCollection aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(namespaceUri matches('http://www.alfresco.org/model.*'))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        aspects.assertThat().entriesListCountIs(100);
        aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(not namespaceUri matches('http://www.alfresco.org/model.*'))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        aspects.assertThat().entriesListCountIs(0);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter aspects using modelId and gets status code OK (200)")
    public void getAspectByModelsIds() throws Exception {
        RestAspectsCollection aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel', 'smf:smartFolder'))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)aspects.getPagination().assertThat().fieldsCount().is((Object)5)).and().field("totalItems").isLessThan(Integer.valueOf(65))).and().field("maxItems").is((Object)100)).and().field("skipCount").isGreaterThan(Integer.valueOf(0))).and().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter aspects using modelId with subaspects and gets status code OK (200)")
    public void getAspectByModelsIdsWithIncludeSubAspects() throws Exception {
        RestAspectsCollection aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel INCLUDESUBASPECTS', 'smf:smartFolder INCLUDESUBASPECTS'))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)aspects.getPagination().assertThat().fieldsCount().is((Object)5)).and().field("totalItems").isGreaterThan(Integer.valueOf(65))).and().field("maxItems").is((Object)100)).and().field("skipCount").isGreaterThan(Integer.valueOf(0))).and().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should filter aspects using parentId and gets status code OK (200)")
    public void getAspectByParentId() throws Exception {
        RestAspectsCollection aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:titled'))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)aspects.getPagination().assertThat().fieldsCount().is((Object)5)).and().field("totalItems").is((Object)5)).and().field("hasMoreItems").is((Object)false);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should Aspects association, properties and mandatory aspects and gets status code OK (200)")
    public void getAspectIncludeParams() throws Exception {
        RestAspectsCollection aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"include=properties,mandatoryAspects,associations"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        for (RestAbstractClassModel aspect : aspects.getEntries()) {
            ((RestAbstractClassModel)((RestAbstractClassModel)aspect.onModel().assertThat().field("associations").isNotNull()).and().field("properties").isNotNull()).and().field("mandatoryAspects").isNotNull();
        }
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Should verify the query errors with possible options")
    public void verifyAspectsQueryError() {
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in (' ')"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel INCLUDESUBASPECTS',))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(modelId in ('cm:contentmodel INCLUDESUBTYPES'))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in (' ')"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:content',))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:content',))&include=properties"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(namespaceUri matches('*'))"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"where=(parentId in ('cm:content'))&include=properties"})).getAspects();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets aspects with high skipCount and maxItems parameter applied")
    public void getPaginationParameter() throws Exception {
        RestAspectsCollection aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"maxItems=10&skipCount=10"})).getAspects();
        aspects.assertThat().entriesListCountIs(10);
        aspects.assertThat().paginationField("hasMoreItems").is("true");
        aspects.assertThat().paginationField("skipCount").is("10");
        aspects.assertThat().paginationField("maxItems").is("10");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets aspects with hasMoreItems applied bases on skip count and maxItems")
    public void getHighPaginationQuery() throws Exception {
        RestAspectsCollection aspects = ((RestModelAPI)this.restClient.authenticateUser(this.regularUser).withModelAPI().usingParams(new String[]{"maxItems=10&skipCount=150"})).getAspects();
        aspects.assertThat().entriesListCountIs(0);
        aspects.assertThat().paginationField("hasMoreItems").is("false");
        aspects.assertThat().paginationField("skipCount").is("150");
        aspects.assertThat().paginationField("maxItems").is("10");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }
}

