/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.requests.People;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FavoritesIncludePathTests
extends RestTest {
    private UserModel adminUser;
    private UserModel testUser1;
    private SiteModel siteModel1;
    private FolderModel folder1;
    private FileModel file1;
    private FolderModel subFolder1;
    private FileModel fileInSubFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUser);
        this.testUser1 = ((DataUser)this.dataUser.usingUser(this.adminUser)).createRandomTestUser();
        this.siteModel1 = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.folder1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel1)).createFolder();
        this.subFolder1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createFolder();
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.folder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.fileInSubFolder = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)this.subFolder1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that get favorite site request does not include Path")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void testGetFavoriteIncludePathForSite() throws Exception {
        ((People)this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().includePath()).getFavorite(this.siteModel1.getGuid());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.onResponse().assertThat().body("entry.target.site.id", Matchers.equalTo((Object)this.siteModel1.getId()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.target.site.path", Matchers.is((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that get favorite file or folder request includes path when requested")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void testGetFavouriteIncludePathForFileFolder() throws Exception {
        Step.STEP((String)"1. Favourite Folder and File");
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addFolderToFavorites(this.folder1);
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addFileToFavorites(this.file1);
        Step.STEP((String)"2. Check Path for Folder: Displayed when requested");
        ((People)this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().includePath()).getFavorite(this.folder1.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.onResponse().assertThat().body("entry.target.folder.id", Matchers.equalTo((Object)this.folder1.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.target.folder.path", Matchers.notNullValue(), new Object[0]);
        Step.STEP((String)"3. Check Path for file: Displayed when requested");
        ((People)this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().includePath()).getFavorite(this.file1.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.onResponse().assertThat().body("entry.target.file.id", Matchers.equalTo((Object)this.file1.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.target.file.path", Matchers.notNullValue(), new Object[0]);
        Step.STEP((String)"4. Check Path for Folder: Not Displayed when not requested");
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getFavorite(this.folder1.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.onResponse().assertThat().body("entry.target.folder.id", Matchers.equalTo((Object)this.folder1.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.target.folder.path", Matchers.nullValue(), new Object[0]);
        Step.STEP((String)"5. Check Path for file: Not Displayed when not requested");
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getFavorite(this.file1.getNodeRefWithoutVersion());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.onResponse().assertThat().body("entry.target.file.id", Matchers.equalTo((Object)this.file1.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.target.file.path", Matchers.nullValue(), new Object[0]);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify path in get favorites")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void testGetFavouritesIncludePath() throws Exception {
        Step.STEP((String)"1. Favourite Folder and File");
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addFolderToFavorites(this.folder1);
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addFileToFavorites(this.file1);
        Step.STEP((String)"2. Check Path: Displayed when appropriate");
        ((People)this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().includePath()).getFavorites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.onResponse().assertThat().body("list.entries.entry.target.folder.id", Matchers.contains((Object[])new String[]{this.folder1.getNodeRefWithoutVersion()}), new Object[0]);
        this.restClient.onResponse().assertThat().body("list.entries.entry.target.folder.path", Matchers.notNullValue(), new Object[0]);
        this.restClient.onResponse().assertThat().body("list.entries.entry.target.file.id", Matchers.contains((Object[])new String[]{this.file1.getNodeRefWithoutVersion()}), new Object[0]);
        this.restClient.onResponse().assertThat().body("list.entries.entry.target.file.path", Matchers.notNullValue(), new Object[0]);
        this.restClient.onResponse().assertThat().body("list.entries.entry.target.site.id", Matchers.contains((Object[])new String[]{this.siteModel1.getId()}), new Object[0]);
        this.restClient.onResponse().assertThat().body("list.entries.entry.target.site.path", Matchers.contains((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify path in post favorites")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void testPostFavouritesIncludePath() throws Exception {
        Step.STEP((String)"1. Favourite Site");
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel1);
        ((People)this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().usingParams(new String[]{"include=path"})).addFavoriteSite(this.siteModel1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.onResponse().assertThat().body("entry.id", Matchers.equalTo((Object)this.siteModel1.getId()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.path", Matchers.nullValue(), new Object[0]);
        Step.STEP((String)"2. Favourite Folder");
        ((People)this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().usingParams(new String[]{"include=path"})).addFolderToFavorites(this.subFolder1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.onResponse().assertThat().body("entry.target.folder.id", Matchers.equalTo((Object)this.subFolder1.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.target.folder.path", Matchers.notNullValue(), new Object[0]);
        Step.STEP((String)"3. Favourite File");
        ((People)this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().includePath()).addFileToFavorites(this.fileInSubFolder);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.onResponse().assertThat().body("entry.target.file.id", Matchers.equalTo((Object)this.fileInSubFolder.getNodeRefWithoutVersion()), new Object[0]);
        this.restClient.onResponse().assertThat().body("entry.target.file.path", Matchers.notNullValue(), new Object[0]);
    }
}

