/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class AddProcessSanityTests
extends RestTest {
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private RestProcessModel addedProcess;
    private RestProcessModelsCollection processes;

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify non network user is able to start new process using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void nonNetworkUserStartsNewProcess() throws JsonToModelConversionException, Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessModel)this.addedProcess.assertThat().field("id").is((Object)this.addedProcess.getId())).and().field("startUserId").is((Object)this.addedProcess.getStartUserId());
        this.processes = this.restClient.withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.processes.assertThat().entriesListContains("id", this.addedProcess.getId());
    }
}

