/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.category;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.repo.resource.category.SerialCategoriesCreator;

public class NestedCategoriesCreator
extends SerialCategoriesCreator {
    public NestedCategoriesCreator(RestWrapper restClient, Map<String, RestCategoryModel> categories) {
        super(restClient, categories);
    }

    @Override
    public List<RestCategoryModel> create() {
        return this.createNestedCategories(this.parent, this.names, 0);
    }

    private List<RestCategoryModel> createNestedCategories(RestCategoryModel parent, List<String> categoryNames, int index) {
        ArrayList<RestCategoryModel> createdCategories = new ArrayList<RestCategoryModel>();
        categoryNames.stream().findFirst().ifPresent(categoryName -> {
            RestCategoryModel createdCategory = this.createCategory((String)categoryName, (String)this.getOrNull(this.aliases, index), parent);
            createdCategories.add(createdCategory);
            List<String> remainingNames = categoryNames.stream().skip(1L).toList();
            if (!remainingNames.isEmpty()) {
                createdCategories.addAll(this.createNestedCategories(createdCategory, remainingNames, index + 1));
            }
        });
        return createdCategories;
    }
}

