/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags.nodes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class AddTagsTests
extends TagsDataPrep {
    private FileModel contributorDoc;
    private String tag1;
    private String tag2;
    private RestTagModelsCollection returnedCollection;

    @BeforeMethod(alwaysRun=true)
    public void generateRandomTagsList() {
        this.tag1 = RandomData.getRandomName((String)"tag").toLowerCase();
        this.tag2 = RandomData.getRandomName((String)"tag").toLowerCase();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user adds multiple tags with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsAbleToAddTags() {
        this.restClient.authenticateUser(adminUserModel);
        this.returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTags(new String[]{this.tag1, this.tag2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)this.returnedCollection.assertThat().entriesListContains("tag", this.tag1)).and().entriesListContains("tag", this.tag2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Manager user adds multiple tags with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void managerIsAbleToAddTags() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTags(new String[]{this.tag1, this.tag2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)this.returnedCollection.assertThat().entriesListContains("tag", this.tag1)).and().entriesListContains("tag", this.tag2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Collaborator user adds multiple tags with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "regression"})
    public void collaboratorIsAbleToAddTags() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTags(new String[]{this.tag1, this.tag2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)this.returnedCollection.assertThat().entriesListContains("tag", this.tag1)).and().entriesListContains("tag", this.tag2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user doesn't have permission to add multiple tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsNotAbleToAddTagsToAnotherContent() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTags(new String[]{this.tag1, this.tag2});
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user adds multiple tags to his content with Rest API and status code is 201")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsAbleToAddTagsToHisContent() {
        userModel = usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(userModel);
        this.contributorDoc = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(userModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.contributorDoc).addTags(new String[]{this.tag1, this.tag2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)this.returnedCollection.assertThat().entriesListContains("tag", this.tag1)).and().entriesListContains("tag", this.tag2);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user doesn't have permission to add multiple tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void consumerIsNotAbleToAddTags() {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)document).addTags(new String[]{this.tag1, this.tag2});
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void userIsNotAbleToAddTagsIfAuthenticationFails() {
        UserModel siteManager = usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        String managerPassword = siteManager.getPassword();
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager).withCoreAPI().usingResource((RepoTestModel)document).addTags(new String[]{this.tag1, this.tag2});
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
        siteManager.setPassword(managerPassword);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify include count parameter")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsUsingCountParam() {
        FileModel file = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String tagName = RandomData.getRandomName((String)"tag");
        returnedModel = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addTag(RandomData.getRandomName((String)"tag"));
        RestTagModelsCollection tagsWithIncludeParamCount = this.restClient.withParams(new String[]{"include=count"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        for (RestTagModel tagModel : tagsWithIncludeParamCount.getEntries()) {
            if (tagModel == null || tagModel.getTag() == null || !tagModel.getTag().equals(tagName)) continue;
            Assert.assertEquals((int)tagModel.getCount(), (int)1);
        }
    }
}

