/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionCoreTests
extends RestTest {
    private UserModel adminUser;
    private RestProcessDefinitionModel randomProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify if get process definition returns status code 404 when invalid processDefinitionId is used")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getProcessDefinitionUsingInvalidProcessDefinitionId() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.restClient.withWorkflowAPI().getAllProcessDefinitions().getOneRandomEntry()).onModel();
        this.randomProcessDefinition.setId("invalidID");
        this.restClient.withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinition();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidID")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

