/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.renditions;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"renditions"})
public class GetRenditionTests
extends RestTest {
    private UserModel user;
    private SiteModel site;
    private FileModel file1;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        this.file1 = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @Bug(id="REPO-2449", status=Bug.Status.FIXED)
    @Test(groups={"rest-api", "renditions", "sanity", "not-supported-by-ats"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify that ZIP document preview is rendered")
    public void verifyPreviewOfZipFile() throws Exception {
        Step.STEP((String)"1. Create a folder in existing site");
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder(folder);
        Step.STEP((String)"2. Upload a local ZIP file using RESTAPI");
        this.restClient.authenticateUser(this.user).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"content-zip-test.zip"));
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        FileModel file = new FileModel("content-zip-test.zip");
        file.setCmisLocation(folder.getCmisLocation() + "/content-zip-test.zip");
        file.setNodeRef(fileNode.getId());
        Step.STEP((String)"3. Create preview of ZIP file using RESTAPI");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)file).createNodeRendition("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Step.STEP((String)"4. Verify preview of ZIP file is created using RESTAPI");
        RestRenditionInfoModel renditionInfo = this.restClient.withCoreAPI().usingNode((RepoTestModel)file).getNodeRenditionUntilIsCreated("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        renditionInfo.assertThat().field("status").is((Object)"CREATED");
    }

    @Bug(id="REPO-2485", status=Bug.Status.FIXED)
    @Test(groups={"rest-api", "renditions", "sanity", "not-supported-by-ats"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify that ZIP document thumbnail is rendered")
    public void verifyThumbnailOfZipFile() throws Exception {
        Step.STEP((String)"1. Create a folder in existing site");
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder(folder);
        Step.STEP((String)"2. Upload a local ZIP file using RESTAPI");
        this.restClient.authenticateUser(this.user).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"content-zip-test.zip"));
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        FileModel file = new FileModel("content-zip-test.zip");
        file.setCmisLocation(folder.getCmisLocation() + "/content-zip-test.zip");
        file.setNodeRef(fileNode.getId());
        Step.STEP((String)"3. Create thumbnail of ZIP file using RESTAPI");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)file).createNodeRendition("doclib");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Step.STEP((String)"4. Verify thumbnail of ZIP file is created and has content using RESTAPI");
        RestRenditionInfoModel renditionInfo = this.restClient.withCoreAPI().usingNode((RepoTestModel)file).getNodeRenditionUntilIsCreated("doclib");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        renditionInfo.assertThat().field("status").is((Object)"CREATED");
        renditionInfo.assertThat().field("content.sizeInBytes").isGreaterThan(Integer.valueOf(120));
    }

    @Test(groups={"rest-api", "renditions", "sanity", "not-supported-by-ats"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify that the rendition content can be downloaded using GET /nodes/{nodeId}/renditions/{renditionId}/content")
    public void getRenditionContent() throws Exception {
        Step.STEP((String)"1. Create a folder in existing site");
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder(folder);
        Step.STEP((String)"2. Upload a local txt file using RESTAPI");
        this.restClient.authenticateUser(this.user).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"iso8859File.txt"));
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        FileModel file = new FileModel("iso8859File.txt");
        file.setCmisLocation(folder.getCmisLocation() + "/iso8859File.txt");
        file.setNodeRef(fileNode.getId());
        Step.STEP((String)"3. Create thumbnail of txt file using RESTAPI");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)file).createNodeRendition("doclib");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Step.STEP((String)"4. Verify thumbnail of txt file is created and has content using RESTAPI");
        RestResponse restResponse = this.restClient.withCoreAPI().usingNode((RepoTestModel)file).getNodeRenditionContentUntilIsCreated("doclib");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Content-Type", "image/png;charset=UTF-8");
        Assert.assertTrue((restResponse.getResponse().body().asInputStream().available() > 0 ? 1 : 0) != 0);
    }

    @Test(groups={"rest-api", "renditions", "sanity"})
    @TestRail(section={"rest-api", "renditions"}, executionType={ExecutionType.SANITY}, description="Verify the Range request header using GET /nodes/{nodeId}/renditions/{renditionId}/content")
    public void getVerifyRangeRequestHeader() throws Exception {
        Step.STEP((String)"1. Create thumbnail on file");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file1).createNodeRendition("pdf");
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Step.STEP((String)"2. Make GET rendition content using content-range header");
        Utility.sleep((int)500, (int)30000, () -> {
            this.restClient.configureRequestSpec().addHeader("content-range", "bytes=1-10");
            this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.file1).getNodeRenditionContent("pdf");
            this.restClient.assertStatusCodeIs(HttpStatus.PARTIAL_CONTENT);
            this.restClient.assertHeaderValueContains("content-range", "bytes 1-10");
            this.restClient.assertHeaderValueContains("content-length", String.valueOf(10));
        });
    }
}

