/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.ratings;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestRatingModel;
import org.alfresco.rest.model.RestRatingModelsCollection;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteRatingTests
extends RestTest {
    private SiteModel siteModel;
    private UserModel adminUser;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestRatingModelsCollection returnedRatingModelCollection;
    private RestRatingModel returnedRatingModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role is able to remove its own rating of a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void managerIsAbleToDeleteItsOwnRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.returnedRatingModelCollection.assertNodeIsNotLiked().assertNodeHasNoFiveStarRating().and().entriesListIsNotEmpty()).and().paginationExist();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role is able to remove its own rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void collaboratorIsAbleToDeleteItsOwnRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.returnedRatingModelCollection.assertNodeIsNotLiked().assertNodeHasNoFiveStarRating().and().entriesListIsNotEmpty()).and().paginationExist();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role is able to remove its own rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void contributorIsAbleToDeleteItsOwnRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.returnedRatingModelCollection.assertNodeIsNotLiked().assertNodeHasNoFiveStarRating().and().entriesListIsNotEmpty()).and().paginationExist();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role is able to remove its own rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void consumerIsAbleToDeleteItsOwnRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.returnedRatingModelCollection.assertNodeIsNotLiked().assertNodeHasNoFiveStarRating().and().entriesListIsNotEmpty()).and().paginationExist();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to remove its own rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void adminIsAbleToDeleteItsOwnRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        document = ((DataContent)this.dataContent.usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.returnedRatingModelCollection.assertNodeIsNotLiked().assertNodeHasNoFiveStarRating().and().entriesListIsNotEmpty()).and().paginationExist();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to remove its own rating of a document")
    @Test(groups={"rest-api", "ratings", "sanity"})
    public void unauthenticatedUserIsNotAbleToDeleteRatings() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        document = ((DataContent)this.dataContent.usingUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.authenticateUser(new UserModel("random user", "random password"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify one user is not able to remove rating added by another user")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="ACE-5459")
    public void oneUserIsNotAbleToDeleteRatingsOfAnotherUser() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        UserModel userA = this.dataUser.createRandomTestUser();
        UserModel userB = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userA);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.authenticateUser(userB);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings().assertNodeIsLiked().assertNodeHasFiveStarRating();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if ratingId provided is unknown status code returned is 400")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void deleteInvalidRating() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).deleteInvalidRating("random_rating");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_RATING, "random_rating")).containsErrorKey(String.format(RestErrorModel.INVALID_RATING, "random_rating")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify that if nodeId does not exist status code returned is 404")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void deleteRatingUsingInvalidDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        document.setNodeRef("random_value");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "random_value"));
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete rating stars for a document that was not rated")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="MNT-17181")
    public void deleteStarsForANotRatedDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete like rating for a document that was not liked")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="MNT-17181")
    public void deleteLikeForANotLikedDocument() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete like for a file then add it again")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void likeDocumentAfterLikeRatingIsDeleted() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete stars for a file then add them again")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addStarsToDocumentAfterRatingIsDeleted() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to remove rating added by another user")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="ACE-5459")
    public void deleteDocumentRatingUsingManager() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings().assertNodeIsLiked().assertNodeHasFiveStarRating();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to remove rating added by another user")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="ACE-5459")
    public void contributorIsNotAbleToDeleteRatingsOfAnotherUser() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings().assertNodeIsLiked().assertNodeHasFiveStarRating();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is not able to remove rating added by another user")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="ACE-5459")
    public void collaboratorIsNotAbleToDeleteRatingsOfAnotherUser() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings().assertNodeIsLiked().assertNodeHasFiveStarRating();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to remove rating added by another user")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="ACE-5459")
    public void consumerIsNotAbleToDeleteRatingsOfAnotherUser() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings().assertNodeIsLiked().assertNodeHasFiveStarRating();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete rating stars twice")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="MNT-17181")
    public void deleteStarsTwice() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedRatingModelCollection.assertNodeHasNoFiveStarRating();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete like rating twice")
    @Test(groups={"rest-api", "ratings", "regression"})
    @Bug(id="MNT-17181")
    public void deleteLikeTwice() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedRatingModelCollection.assertNodeIsNotLiked();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)document).deleteLikeRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete like for a folder then add it again")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void likeFolderAfterLikeRatingIsDeleted() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).deleteLikeRating();
        this.returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete stars for a folder then add them again")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addStarsToFolderAfterRatingIsDeleted() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete like for a site then add it again")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void likeSiteAfterLikeRatingIsDeleted() throws Exception {
        FolderModel folderModel = new FolderModel();
        folderModel.setNodeRef(this.siteModel.getGuid());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).deleteLikeRating();
        this.returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).likeDocument();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"true")).and().field("id").is((Object)"likes")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Delete stars for a site then add them again")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void addStarsToSiteAfterRatingIsDeleted() throws Exception {
        FolderModel folderModel = new FolderModel();
        folderModel.setNodeRef(this.siteModel.getGuid());
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).rateStarsToDocument(5);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestRatingModel)((RestRatingModel)this.returnedRatingModel.assertThat().field("myRating").is((Object)"5")).and().field("id").is((Object)"fiveStar")).and().field("aggregate").isNotEmpty();
    }

    @TestRail(section={"rest-api", "ratings"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Manager role is able to remove one star rating of a document")
    @Test(groups={"rest-api", "ratings", "regression"})
    public void removeOneStarRating() throws Exception {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createFolder();
        FileModel document = ((DataContent)this.dataContent.usingUser(this.adminUser).usingResource((ContentModel)folderModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).rateStarsToDocument(1);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteFiveStarRating();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.returnedRatingModelCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getRatings();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.returnedRatingModelCollection.assertNodeIsNotLiked().assertNodeHasNoFiveStarRating().and().entriesListIsNotEmpty()).and().paginationExist();
    }
}

