/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableCollection;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessVariablesFullTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel adminUser;
    private ProcessModel processModel;
    private RestProcessModel restProcessModel;
    private RestProcessVariableModel variableModel;
    private RestProcessVariableModel processVariable;
    private RestProcessVariableModel variableModel1;
    private RestProcessVariableModel variableModel2;
    private RestProcessVariableModel variableModel3;
    private RestProcessVariableCollection processVariableCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add process variables using by the user involved in the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableByUserInvolvedTheProcess() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariable = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add process variables using by the user involved in the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addMultipleProcessVariableByUserInvolvedTheProcess() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariableCollection = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(0)).onModel().assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(1)).onModel().assertThat().field("name").is((Object)this.variableModel1.getName())).and().field("type").is((Object)this.variableModel1.getType())).and().field("value").is((Object)this.variableModel1.getValue());
        ((RestModels)this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName())).assertThat().entriesListContains("name", this.variableModel1.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add process variables using by inexistent user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableByInexistentUser() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariable = this.restClient.authenticateUser(UserModel.getRandomUserModel()).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add multiple process variables using by inexistent user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addMultipleProcessVariableByInexistentUser() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariableCollection = this.restClient.authenticateUser(UserModel.getRandomUserModel()).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid type is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidTypeIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:textarea");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d:textarea")).containsErrorKey(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d:textarea")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1938")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid type prefix is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidTypePrefixIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"ddt:text");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_NAMEPACE_PREFIX, "ddt")).containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidValueIsProvided() throws Exception {
        RestProcessVariableModel variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:int");
        variableModel.setValue("invalidValue");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.FOR_INPUT_STRING, "invalidValue")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid variableBody (adding extra parameter in body:scope) is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidBodyIsProvided() throws Exception {
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"name\": \"variableName\",\"scope\": \"local\",\"value\": \"testing\",\"type\": \"d:text\"}", (String)"processes/{processId}/variables", (String[])new String[]{this.processModel.getId()});
        this.restClient.processModel(RestProcessVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"scope\"")).containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"scope\"")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case empty name is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfEmptyNameIsProvided() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        RestProcessVariableModel variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        variableModel.setName("");
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.VARIABLE_NAME_REQUIRED).containsErrorKey(RestErrorModel.VARIABLE_NAME_REQUIRED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid name is provided: ony white spaces")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableUsingOnlyWhiteSpaceInName() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel.setName(" ");
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").isNull()).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).getProcessVariables().assertThat().entriesListContains("value", this.variableModel.getValue());
    }

    @Bug(id="REPO-1987")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid name is provided: symbols")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableWithSymbolsInName() throws Exception {
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel.setName("123_%^&: \u00f5\u00c8,\u00cc,\u00d2");
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add two process variables using by the user involved in the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addingMultipleValidProcessVariables() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel2 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel3 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariableCollection = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel2, this.variableModel3});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)((RestModels)this.processVariableCollection.assertThat().entriesListContains("name", this.variableModel.getName())).assertThat().entriesListContains("name", this.variableModel2.getName())).assertThat().entriesListContains("name", this.variableModel3.getName());
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(0)).onModel().assertThat().field("name").is((Object)this.variableModel.getName())).and().field("value").is((Object)this.variableModel.getValue())).and().field("type").is((Object)this.variableModel.getType());
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(1)).onModel().assertThat().field("name").is((Object)this.variableModel2.getName())).and().field("value").is((Object)this.variableModel2.getValue())).and().field("type").is((Object)this.variableModel2.getType());
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(2)).onModel().assertThat().field("name").is((Object)this.variableModel3.getName())).and().field("value").is((Object)this.variableModel3.getValue())).and().field("type").is((Object)this.variableModel3.getType());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add two process variables using by the user involved in the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingMultipleProcessVariablesInvalidType() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel.setType("d:string");
        this.variableModel2 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariableCollection = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel2});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d:string")).containsErrorKey(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d:string")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1938")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add two process variables using by the user involved in the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failledAddingMultipleProcessVariablesInvalidTypePrefix() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel.setType("e:text");
        this.variableModel2 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariableCollection = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel2});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_NAMEPACE_PREFIX, "e")).containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failledAddingMultipleProcessVariablesInvalidValue() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:int");
        this.variableModel.setValue("invalidValue");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel2 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariableCollection = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel1, this.variableModel2});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.FOR_INPUT_STRING, "invalidValue")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variables is falling in case invalid value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failledAddingMultipleInvalidProcessVariables() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:int");
        this.variableModel.setValue("invalidValue");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel1.setType("");
        this.restProcessModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.processVariableCollection = this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel1, this.variableModel});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.FOR_INPUT_STRING, "invalidValue")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

