/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.model;

import java.util.List;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestRatingModel;
import org.alfresco.utility.report.log.Step;
import org.testng.Assert;

public class RestRatingModelsCollection
extends RestModels<RestRatingModel, RestRatingModelsCollection> {
    public RestRatingModelsCollection assertNodeIsLiked() {
        Step.STEP((String)"REST API: Assert that document is liked");
        Assert.assertTrue((this.getNumberOfRatingsFor("likes") > 0 ? 1 : 0) != 0, (String)"Node should have like ratings");
        return this;
    }

    public RestRatingModelsCollection assertNodeIsNotLiked() {
        Step.STEP((String)"REST API: Assert that document is not liked");
        Assert.assertTrue((this.getNumberOfRatingsFor("likes") == 0 ? 1 : 0) != 0, (String)"Node should have no like ratings");
        return this;
    }

    public RestRatingModelsCollection assertNodeHasFiveStarRating() {
        Step.STEP((String)"REST API: Assert that document has five star rating");
        Assert.assertTrue((this.getNumberOfRatingsFor("fiveStar") > 0 ? 1 : 0) != 0, (String)"Node should have five star ratings");
        return this;
    }

    public RestRatingModelsCollection assertNodeHasNoFiveStarRating() {
        Step.STEP((String)"REST API: Assert that document has no five star rating");
        Assert.assertTrue((this.getNumberOfRatingsFor("fiveStar") == 0 ? 1 : 0) != 0, (String)"Node should have no five star ratings");
        return this;
    }

    public int getNumberOfRatingsFor(String ratingValue) {
        List ratings = this.getEntries();
        int noOfRatings = 0;
        for (int i = 0; i < ratings.size(); ++i) {
            if (!((RestRatingModel)ratings.get(i)).onModel().getId().equals(ratingValue)) continue;
            noOfRatings = ((RestRatingModel)ratings.get(i)).onModel().getAggregate().getNumberOfRatings();
        }
        return noOfRatings;
    }
}

