/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.search;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'gethin' on '2017-03-23 10:59' from 'Alfresco Search REST API' swagger file Generated from 'Alfresco Search REST API' swagger file Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestRequestFacetFieldModel extends TestModel implements IRestModel<RestRequestFacetFieldModel>
{
    @JsonProperty(value = "entry")
    RestRequestFacetFieldModel model;

    @Override
    public RestRequestFacetFieldModel onModel()
    {
        return model;
    }

    public RestRequestFacetFieldModel()
    {
        super();
    }

    public RestRequestFacetFieldModel(String field)
    {
        super();
        this.field = field;
    }

    public RestRequestFacetFieldModel(String field, String prefix)
    {
        super();
        this.field = field;
        this.prefix = prefix;
    }

    public RestRequestFacetFieldModel(String field, String label, Integer minCount)
    {
        super();
        this.setField(field);
        this.setLabel(label);

        if (minCount != null)
        {
            this.setMincount(minCount);
        }
    }

    /**
     * The facet field
     */

    private String field;
    /**
     * A label to include in place of the facet field
     */

    private String label;
    /**
     * Restricts the possible constraints to only indexed values with a specified prefix.
     */

    private String prefix;

    private String sort;

    private String method;
    /**
     * When true, count results that match the query but which have no facet value for the field (in addition to the Term-based constraints).
     */

    private boolean missing;

    private int limit;

    private int offset;
    /**
     * The minimum count required for a facet field to be included in the response.
     */

    private int mincount;

    private int facetEnumCacheMinDf;
    /**
     * Filter Queries with tags listed here will not be included in facet counts. This is used for multi-select facetting.
     * 
     */

    private List<String> excludeFilters;

    public String getField()
    {
        return this.field;
    }

    public void setField(String field)
    {
        this.field = field;
    }

    public String getLabel()
    {
        return this.label;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }

    public String getPrefix()
    {
        return this.prefix;
    }

    public void setPrefix(String prefix)
    {
        this.prefix = prefix;
    }

    public String getSort()
    {
        return this.sort;
    }

    public void setSort(String sort)
    {
        this.sort = sort;
    }

    public String getMethod()
    {
        return this.method;
    }

    public void setMethod(String method)
    {
        this.method = method;
    }

    public boolean getMissing()
    {
        return this.missing;
    }

    public void setMissing(boolean missing)
    {
        this.missing = missing;
    }

    public int getLimit()
    {
        return this.limit;
    }

    public void setLimit(int limit)
    {
        this.limit = limit;
    }

    public int getOffset()
    {
        return this.offset;
    }

    public void setOffset(int offset)
    {
        this.offset = offset;
    }

    public int getMincount()
    {
        return this.mincount;
    }

    public void setMincount(int mincount)
    {
        this.mincount = mincount;
    }

    public int getFacetEnumCacheMinDf()
    {
        return this.facetEnumCacheMinDf;
    }

    public void setFacetEnumCacheMinDf(int facetEnumCacheMinDf)
    {
        this.facetEnumCacheMinDf = facetEnumCacheMinDf;
    }

    public List<String> getExcludeFilters()
    {
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<String> excludeFilters)
    {
        this.excludeFilters = excludeFilters;
    }
}
