/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class DeleteTagsTests
extends TagsDataPrep {
    @Test(groups={"rest-api"})
    public void testDeleteTag() {
        Step.STEP((String)"Create a tag assigned to a document and send a request to delete it.");
        document = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestTagModel aTag = this.createTagForDocument(document);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingTag(aTag).deleteTag();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"Ensure that the tag has been deleted by sending a GET request and receiving 404.");
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().getTag(aTag);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api"})
    public void testDeleteTagAsSiteManager_andFail() {
        Step.STEP((String)"Create a tag assigned to a document and attempt to delete as a site manager");
        document = ((DataContent)this.dataContent.usingUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).usingSite(siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestTagModel aTag = this.createTagForDocument(document);
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingTag(aTag).deleteTag();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Current user does not have permission to manage a tag");
    }

    @Test(groups={"rest-api"})
    public void testDeleteNonExistentTag() {
        Step.STEP((String)"Attempt to delete tag with non-existent id and receive 404 error");
        String id = "non-existing-dummy-id";
        RestTagModel tagModel = this.createTagModelWithId("non-existing-dummy-id");
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingTag(tagModel).deleteTag();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }
}

