/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleModelsCollection;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.junit.Assert;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class DeleteRulesTests
extends RulesRestTest {
    private static final String FAKE_NODE_REF = "fake-node-id";
    private UserModel user;
    private SiteModel site;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create a Contributor user and a public site");
        this.user = this.dataUser.createRandomTestUser();
        this.user.setUserRole(UserRole.SiteContributor);
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void deleteSingleRuleAndGet204() {
        Step.STEP((String)"Create a few rules in the folder");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        List createdRules = Stream.of("ruleA", "ruleB", "ruleC").map(ruleName -> {
            RestRuleModel ruleModel = this.rulesUtils.createRuleModel((String)ruleName);
            return this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        }).collect(Collectors.toList());
        Step.STEP((String)"Attempt delete one rule");
        RestRuleModel ruleA = (RestRuleModel)createdRules.get(0);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().deleteRule(ruleA.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"Get and check the rules from the folder after deleting one of them");
        RestRuleModelsCollection rulesAfterDeletion = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        rulesAfterDeletion.assertThat().entriesListCountIs(createdRules.size() - 1);
        Assert.assertTrue((boolean)rulesAfterDeletion.getEntries().stream().noneMatch(r -> r.onModel().getId().equals(ruleA.getId())));
        Set ruleIdsThatShouldBeLeft = createdRules.stream().filter(r -> !r.getName().equals("ruleA")).map(RestRuleModel::getId).collect(Collectors.toSet());
        Set ruleIdsAfterDeletion = rulesAfterDeletion.getEntries().stream().map(r -> r.onModel().getId()).collect(Collectors.toSet());
        Assert.assertEquals(ruleIdsThatShouldBeLeft, ruleIdsAfterDeletion);
    }

    @Test(groups={"rest-api", "rules"})
    public void deleteRuleInNonExistingFolderAndGet404() {
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel testRule = this.createRule(ruleFolder);
        Step.STEP((String)"Create a non-existing folder model");
        FolderModel nonExistingFolder = new FolderModel();
        nonExistingFolder.setNodeRef(FAKE_NODE_REF);
        Step.STEP((String)"Attempt delete the rule in non-existing folder");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)nonExistingFolder).usingDefaultRuleSet().deleteRule(testRule.getId());
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void deleteRuleInNonExistingRuleSetAndGet404() {
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel testRule = this.createRule(ruleFolder);
        Step.STEP((String)"Attempt delete the rule in non-existing rule set");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingRuleSet(FAKE_NODE_REF).deleteRule(testRule.getId());
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void deleteNonExistingRuleAndGet404() {
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Attempt delete non-existing rule");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().deleteRule(FAKE_NODE_REF);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void deleteExistingRuleFromWrongFolderAndGet404() {
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel testRule = this.createRule(ruleFolder);
        Step.STEP((String)"Create a second folder in the site");
        FolderModel anotherFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Attempt delete an existing rule from a wrong but existing (second) folder");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)anotherFolder).usingDefaultRuleSet().deleteRule(testRule.getId());
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND);
    }

    public void deleteSinglePrivateRuleWithoutPermissionAndGet403() {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder with a rule");
        UserModel privateUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(privateUser)).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(privateUser).usingSite(privateSite)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("Private site rule");
        RestRuleModel createdRule = this.restClient.authenticateUser(privateUser).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Try to delete the rule with another user");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().deleteRule(createdRule.getId());
        this.restClient.assertLastError().statusCodeIs(HttpStatus.FORBIDDEN);
    }

    public void deleteSinglePublicRuleAsCollaboratorAndGet403() {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder with a rule");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        RestRuleModel testRule = this.createRule(ruleFolder);
        Step.STEP((String)"Create a manager in the private site");
        UserModel siteCollaborator = this.dataUser.createRandomTestUser();
        siteCollaborator.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.user).withCoreAPI().usingSite(this.site).addPerson(siteCollaborator);
        Step.STEP((String)"Check the manager can delete the rule");
        this.restClient.authenticateUser(siteCollaborator).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().deleteRule(testRule.getId());
        this.restClient.assertLastError().statusCodeIs(HttpStatus.FORBIDDEN);
    }

    public void deleteSinglePrivateRuleAsSiteManagerAndGet204() {
        Step.STEP((String)"Create a user and use them to create a private site containing a folder with a rule");
        UserModel privateUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(privateUser)).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingUser(privateUser).usingSite(privateSite)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("Private site rule");
        RestRuleModel createdRule = this.restClient.authenticateUser(privateUser).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Create a manager in the private site");
        UserModel siteManager = this.dataUser.createRandomTestUser();
        siteManager.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(privateUser).withCoreAPI().usingSite(privateSite).addPerson(siteManager);
        Step.STEP((String)"Check the manager can delete the rule");
        this.restClient.authenticateUser(siteManager).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().deleteRule(createdRule.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    private RestRuleModel createRule(FolderModel ruleFolder) {
        Step.STEP((String)"Create a rule in the folder");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("Test rule");
        return this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
    }
}

