/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.members;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddSiteMemberTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private DataUser.ListUserWithRoles publicSiteUsersWithRoles;
    private DataUser.ListUserWithRoles moderatedSiteUsersWithRoles;
    private DataUser.ListUserWithRoles privateSiteUsersWithRoles;
    private String addMemberJson;
    private String addMembersJson;
    private RestSiteMemberModel memberModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPrivateRandomSite();
        this.publicSiteUsersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.moderatedSiteUsersWithRoles = this.dataUser.addUsersWithRolesToSite(this.moderatedSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.privateSiteUsersWithRoles = this.dataUser.addUsersWithRolesToSite(this.privateSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.addMemberJson = "{\"role\":\"%s\",\"id\":\"%s\"}";
        this.addMembersJson = "{\"role\":\"%s\",\"id\":\"%s\"}, {\"role\":\"%s\",\"id\":\"%s\"}";
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that manager is able to add site member and gets status code CREATED (201)")
    public void managerIsAbleToAddSiteMember() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser).assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site collaborator is not able to add site member and gets status code FORBIDDEN (403)")
    public void collaboratorIsNotAbleToAddSiteMember() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertLastError().containsSummary("Permission was denied");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site contributor is not able to add site member and gets status code FORBIDDEN (403)")
    public void contributorIsNotAbleToAddSiteMember() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertLastError().containsSummary("Permission was denied");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site consumer is not able to add site member and gets status code FORBIDDEN (403)")
    public void consumerIsNotAbleToAddSiteMember() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertLastError().containsSummary("Permission was denied");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that admin user is able to add site member and gets status code CREATED (201)")
    public void adminIsAbleToAddSiteMember() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        ((RestSiteMemberModel)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser).and().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that unauthenticated user is not able to add site member")
    public void unauthenticatedUserIsNotAuthorizedToAddSiteMmeber() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        UserModel userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can add another user as manager to a public site and gets status code CREATED (201)")
    public void addManagerToPublicSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can add another user as manager to a moderated site and gets status code CREATED (201)")
    public void addManagerToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can add another user as manager to a private site and gets status code CREATED (201)")
    public void addManagerToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer role is not able to add another user to a moderated site and gets status code 403")
    public void addUserByConsumerToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.moderatedSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer role is not able to add another user to a private site and gets status code 403")
    public void addUserByConsumerToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.privateSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator role is not able to add another user to a moderated site and gets status code 403")
    public void addUserByCollaboratorToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.moderatedSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator role is not able to add another user to a private site and gets status code 403")
    public void addUserByCollaboratorToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.privateSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor role is not able to add another user to a moderated site and gets status code 403")
    public void addUserByContributorToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.moderatedSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor role is not able to add another user to a private site and gets status code 403")
    public void addUserByContributorToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.privateSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that a user without specified role can not be added to a site and gets status code 400")
    public void canNotAddUserWithoutSpecifyingRoleToSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String json = JsonBodyGenerator.keyValueJson((String)"id", (String)testUser.getUsername());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.MUST_PROVIDE_ROLE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that a user with inexistent role can not be added to a site and gets status code 400")
    public void canNotAddUserWithInexistentRoleToSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)String.format("{\"role\":\"inexistentRole\",\"id\":\"%s\"}", testUser.getUsername()), (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNKNOWN_ROLE, "inexistentRole"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can not add himself as a manager to a public site and gets status code 403")
    public void userAddHimselfAsManagerToPublicSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(testUser).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can not add himself as a manager to a moderated site and gets status code 403")
    public void userAddHimselfAsManagerToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(testUser).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can not add himself as a manager to a private site and gets status code 404")
    public void userAddHimselfAsManagerToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(testUser).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.privateSiteModel.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can not be added to an inexistent site and gets status code 404")
    public void userIsNotAbleToAddUserToAnInexistentSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteManager);
        SiteModel inexistentSite = new SiteModel("inexistentSite");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(inexistentSite).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentSite.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user can not be added to site and gets status code 404")
    public void userIsNotAbleToAddInexistentUserToSite() throws Exception {
        UserModel testUser = new UserModel("inexistentUser", "password");
        testUser.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, testUser.getUsername())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that empty username can not be added to site and gets status code 400")
    public void userIsNotAbleToAddEmptyUserIdToSite() throws Exception {
        UserModel testUser = new UserModel("", "password");
        testUser.setUserRole(UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, testUser.getUsername()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can not add another user that is already a memeber and gets status code 409")
    public void userIsNotAbleToAddUserThatIsAlreadyAMember() throws Exception {
        UserModel collaborator = this.moderatedSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(collaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_Site_MEMBER, collaborator.getUsername(), this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that several users with different roles can be added once in a row to a site and gets status code 201")
    public void addSeveralUsersWithDifferentRolesToASite() throws Exception {
        UserModel firstUser = this.dataUser.createRandomTestUser("testUser");
        firstUser.setUserRole(UserRole.SiteContributor);
        UserModel secondUser = this.dataUser.createRandomTestUser("testUser");
        secondUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String json = String.format(this.addMembersJson, firstUser.getUserRole(), firstUser.getUsername(), secondUser.getUserRole(), secondUser.getUsername());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that several users with same roles can be added once in a row to a site and gets status code 201")
    public void addSeveralUsersWithSameRolesToASite() throws Exception {
        UserModel firstUser = this.dataUser.createRandomTestUser("testUser");
        firstUser.setUserRole(UserRole.SiteCollaborator);
        UserModel secondUser = this.dataUser.createRandomTestUser("testUser");
        secondUser.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String json = String.format(this.addMembersJson, firstUser.getUserRole(), firstUser.getUsername(), secondUser.getUserRole(), secondUser.getUsername());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that several users that are already added to the site can not be added once in a row and gets status code 400")
    public void addSeveralUsersThatAreAlreadyAddedToASite() throws Exception {
        UserModel collaborator = this.moderatedSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        UserModel consumer = this.moderatedSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String json = String.format(this.addMembersJson, collaborator.getUserRole(), collaborator.getUsername(), consumer.getUserRole(), consumer.getUsername());
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.moderatedSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_Site_MEMBER, collaborator.getUsername(), this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Add new site member request by providing an empty body")
    public void addSiteMemberUsingEmptyBody() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"", (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check lower and upper case letters for role field")
    public void checkLowerUpperCaseLettersForRole() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        String json = String.format(this.addMemberJson, "SITEMANAGER", user.getUsername());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNKNOWN_ROLE, "SITEMANAGER")).containsErrorKey(String.format(RestErrorModel.UNKNOWN_ROLE, "SITEMANAGER")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        json = String.format(this.addMemberJson, "sitemanager", user.getUsername());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNKNOWN_ROLE, "sitemanager")).containsErrorKey(String.format(RestErrorModel.UNKNOWN_ROLE, "sitemanager")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check empty value for user role")
    public void checkEmptyValueForRole() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        String json = String.format(this.addMemberJson, "", user.getUsername());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "N/A")).containsSummary(String.format(RestErrorModel.NO_CONTENT, "N/A")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor role can be added to public site")
    public void addContributorToPublicSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteContributor);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator role can be added to moderated site")
    public void addCollaboratorToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteCollaborator);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor role can be added to moderated site")
    public void addContributorToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteContributor);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer role can be added to moderated site")
    public void addConsumerToModeratedSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator role can be added to private site")
    public void addCollaboratorToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteCollaborator);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor role can be added to private site")
    public void addContributorToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteContributor);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer role can be added to private site")
    public void addConsumerToPrivateSite() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser("testUser");
        testUser.setUserRole(UserRole.SiteConsumer);
        this.memberModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).addPerson(testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)testUser.getUsername())).and().field("role").is((Object)testUser.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can be added to private site by site manager")
    public void adminCanBeAddedToPrivateSiteBySiteManager() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(testUser)).createPrivateRandomSite();
        this.adminUserModel.setUserRole(UserRole.SiteContributor);
        this.memberModel = this.restClient.authenticateUser(testUser).withCoreAPI().usingSite(privateSite).addPerson(this.adminUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMemberModel)this.memberModel.assertThat().field("id").is((Object)this.adminUserModel.getUsername())).and().field("role").is((Object)this.adminUserModel.getUserRole());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin cannot be added to private site by site collaborator")
    public void adminCannotBeAddedToPrivateSiteBySiteCollaborator() throws Exception {
        UserModel testUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(testUser)).createPrivateRandomSite();
        UserModel siteCollaborator = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(siteCollaborator, privateSite, UserRole.SiteCollaborator);
        this.adminUserModel.setUserRole(UserRole.SiteContributor);
        this.memberModel = this.restClient.authenticateUser(siteCollaborator).withCoreAPI().usingSite(privateSite).addPerson(this.adminUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }
}

