/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddTaskItemTestsBulk2
extends RestTest {
    private UserModel userModel;
    private UserModel assigneeUser;
    private UserModel anotherUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private FileModel fileModel1;
    private TaskModel taskModel;
    private String taskId;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.fileModel1 = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.taskId = this.taskModel.getId();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Add task item using random user.")
    public void addTaskItemByRandomUser() throws Exception {
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Add multiple task item using random user.")
    public void addMultipleTaskItemByRandomUser() throws Exception {
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.fileModel, this.fileModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="ACE-5683")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task item, is falling in case invalid itemBody is provided")
    public void failedAddingTaskItemIfInvalidItemBodyIsProvided() throws Exception {
        this.fileModel.setNodeRef("invalidNodeRef");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidNodeRef")).containsErrorKey(RestErrorModel.NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="ACE-5683")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task item, is falling in case invalid itemBody is provided")
    public void failedAddingMultipleTaskItemIfInvalidItemBodyIsProvided() throws Exception {
        this.fileModel.setNodeRef("invalidNodeRef");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.fileModel, this.fileModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidNodeRef")).containsErrorKey(RestErrorModel.NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="ACE-5675")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task item is falling in case empty item body is provided")
    public void failedAddingTaskItemIfEmptyItemBodyIsProvided() throws Exception {
        this.fileModel.setNodeRef("");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("");
    }

    @Bug(id="ACE-5675")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task item is falling in case empty item body is provided")
    public void failedAddingMultipleTaskItemIfEmptyItemBodyIsProvided() throws Exception {
        this.fileModel.setNodeRef("");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.fileModel, this.fileModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task item is falling in case invalid task id is provided")
    public void failedAddingTaskItemIfInvalidTaskIdIsProvided() throws Exception {
        this.taskModel.setId("invalidTaskId");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidTaskId")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task item is falling in case invalid task id is provided")
    public void failedAddingMultipleTaskItemIfInvalidTaskIdIsProvided() throws Exception {
        this.taskModel.setId("invalidTaskId");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskItems(new FileModel[]{this.fileModel, this.fileModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidTaskId")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="ACE-5675")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task item is falling in case incomplete body type is provided")
    public void failedAddingTaskVariableIfIncompleteBodyIsProvided() throws Exception {
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{}", (String)"tasks/{taskId}/items", (String[])new String[]{this.taskId});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("");
    }
}

