/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestAuditAppModel;
import org.alfresco.rest.model.RestAuditAppModelsCollection;
import org.alfresco.rest.model.RestAuditEntryModel;
import org.alfresco.rest.model.RestAuditEntryModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class Audit
extends ModelRequest<Audit> {
    public Audit(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public RestAuditAppModelsCollection getAuditApplications() throws JsonToModelConversionException {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "audit-applications?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestAuditAppModelsCollection.class, request);
    }

    public RestAuditAppModel getAuditApp(RestAuditAppModel restAuditAppModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "audit-applications/{auditApplicationId}?{parameters}", restAuditAppModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestAuditAppModel.class, request);
    }

    public RestAuditEntryModelsCollection listAuditEntriesForAnAuditApplication(String auditApplicationId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "audit-applications/{auditApplicationId}/audit-entries?{parameters}", auditApplicationId, this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestAuditEntryModelsCollection.class, request);
    }

    public RestAuditAppModel updateAuditApp(RestAuditAppModel restAuditAppModel, String key, String value) {
        String postBody = JsonBodyGenerator.keyValueJson(key, value);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, postBody, "audit-applications/{auditApplicationId}", restAuditAppModel.getId());
        return this.restWrapper.processModel(RestAuditAppModel.class, request);
    }

    public RestAuditEntryModel getAuditEntryForAnAuditApplication(String auditApplicationId, String auditEntryId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "audit-applications/{auditApplicationId}/audit-entries/{auditEntryId}?{parameters}", auditApplicationId, auditEntryId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestAuditEntryModel.class, request);
    }

    public void deleteAuditEntryForAnAuditApplication(String auditApplicationId, String auditEntryId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "audit-applications/{auditApplicationId}/audit-entries/{auditEntryId}", auditApplicationId, auditEntryId);
        this.restWrapper.processEmptyModel(request);
    }

    public void deleteAuditEntriesForAnAuditApplication(String auditApplicationId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "audit-applications/{auditApplicationId}/audit-entries?{parameters}", auditApplicationId, this.restWrapper.getParameters());
        this.restWrapper.processEmptyModel(request);
    }

    public RestAuditEntryModelsCollection listAuditEntriesForNode(String nodeId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/audit-entries?{parameters}", nodeId, this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestAuditEntryModelsCollection.class, request);
    }
}

