/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.preferences;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestPreferenceModelsCollection;
import org.alfresco.utility.constants.PreferenceName;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeoplePreferencesSanityTests
extends RestTest {
    UserModel userModel;
    SiteModel siteModel;
    private RestPreferenceModelsCollection restPreferenceModelsCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify manager user gets its preferences with Rest API and response is successful (200)")
    public void managerUserGetsPeoplePreferencesWithSuccess() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify collaborator user gets its preferences with Rest API and response is successful (200)")
    public void collaboratorUserGetsPeoplePreferencesWithSuccess() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(collaboratorUser, this.siteModel, UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingAuthUser().getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify contributor user gets its preferences with Rest API and response is successful (200)")
    public void contributorUserGetsPeoplePreferencesWithSuccess() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser, this.siteModel, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(contributorUser).withCoreAPI().usingAuthUser().getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify consumer user gets its preferences with Rest API and response is successful (200)")
    public void consumerUserGetsPeoplePreferencesWithSuccess() throws Exception {
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, this.siteModel, UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(consumerUser).withCoreAPI().usingAuthUser().getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets another user preferences with Rest API and response is successful (200)")
    public void adminUserGetsPeoplePreferencesWithSuccess() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel)).addSiteToFavorites();
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restPreferenceModelsCollection = this.restClient.authenticateUser(adminUser).withCoreAPI().usingUser(managerUser).getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restPreferenceModelsCollection.assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().entriesListContains("id", String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify manager user is NOT Authorized to gets its preferences with Rest API when authentication fails(401)")
    public void managerUserGetsPeoplePreferencesIsNotAuthorized() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel)).addSiteToFavorites();
        managerUser.setPassword("newpassword");
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().getPersonPreferences();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

