/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.preferences;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestPreferenceModel;
import org.alfresco.utility.constants.PreferenceName;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeoplePreferenceSanityTests
extends RestTest {
    UserModel userModel;
    SiteModel siteModel;
    private RestPreferenceModel restPreferenceModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify manager user gets a specific preference with Rest API and response is successful (200)")
    public void managerUserGetsAPreferenceWithSuccess() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModel = this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify collaborator user gets a specific preference with Rest API and response is successful (200)")
    public void collaboratorUserGetsAPreferenceWithSuccess() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(collaboratorUser, this.siteModel, UserRole.SiteCollaborator);
        ((DataSite)((DataSite)this.dataSite.usingUser(collaboratorUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModel = this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify collaborator user gets a specific preference with Rest API and response is successful (200)")
    public void collaboratorUserUpdatesAPreferenceWithSuccess() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        RestPreferenceModel updatedRestPreferenceModel = new RestPreferenceModel();
        updatedRestPreferenceModel.setId("user.preference");
        updatedRestPreferenceModel.setValue("user.value");
        this.restPreferenceModel = this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingAuthUser().updatePersonPreferenceInformation(updatedRestPreferenceModel.getId(), updatedRestPreferenceModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)"user.preference")).and().field("value").is((Object)"user.value");
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify contributor user gets a specific preference with Rest API and response is successful (200)")
    public void contributorUserGetsAPreferenceWithSuccess() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser, this.siteModel, UserRole.SiteContributor);
        ((DataSite)((DataSite)this.dataSite.usingUser(contributorUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModel = this.restClient.authenticateUser(contributorUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify consumer user gets a specific preference with Rest API and response is successful (200)")
    public void consumerUserGetsAPreferenceWithSuccess() throws Exception {
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, this.siteModel, UserRole.SiteConsumer);
        ((DataSite)((DataSite)this.dataSite.usingUser(consumerUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModel = this.restClient.authenticateUser(consumerUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets a specific preference with Rest API and response is successful (200)")
    public void adminUserGetsAPreferenceWithSuccess() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        ((DataSite)((DataSite)this.dataSite.usingUser(adminUser)).usingSite(this.siteModel)).addSiteToFavorites();
        this.restPreferenceModel = this.restClient.authenticateUser(adminUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPreferenceModel)this.restPreferenceModel.assertThat().field("id").is((Object)String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()))).and().field("value").is((Object)"true");
    }

    @Test(groups={"rest-api", "people", "preferences", "sanity"})
    @TestRail(section={"rest-api", "people", "preferences"}, executionType={ExecutionType.SANITY}, description="Verify manager user is NOT Authorized to get a specific preference with Rest API when authentication fails (401)")
    public void managerUserNotAuthorizedFailsToGetsAPreference() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.siteModel, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.siteModel)).addSiteToFavorites();
        managerUser.setPassword("newpassword");
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().getPersonPreferenceInformation(String.format(PreferenceName.SITES_FAVORITES_PREFIX.toString(), this.siteModel.getId()));
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

