/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateTaskVariableTestsBulk2
extends RestTest {
    private UserModel userModel;
    private SiteModel siteModel;
    private FileModel fileModel;
    private UserModel assigneeUser;
    private TaskModel taskModel;
    private RestVariableModel taskVariable;
    private RestVariableModel variableModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Update task variable by user who started the process")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void updateTaskVariableByUserWhoStartedProcess() throws Exception {
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setValue((Object)"new-value");
        this.variableModel.setName("new-name");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestVariableModel)this.taskVariable.assertThat().field("value").is((Object)"new-value")).and().field("name").is((Object)"new-name");
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with symbols in name")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithSymbolsInName() throws Exception {
        String symbolName = "<>.,;-'+=%|[]#*&-+";
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setName(symbolName);
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskVariable.assertThat().field("name").is((Object)symbolName);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid task id")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidTaskId() throws Exception {
        TaskModel invalidTask = new TaskModel(this.userModel.getUsername());
        invalidTask.setId("invalid-task-id");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(invalidTask).updateTaskVariable(RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text"));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, invalidTask.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid scope")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidScope() throws Exception {
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setScope("invalid-scope");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.ILLEGAL_SCOPE, "invalid-scope"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid type")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithInvalidType() throws Exception {
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setType("d:invalidType");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d:invalidType"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with symbols in value")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableWithSymbolsInValue() throws Exception {
        String symbolValue = "<>.,;-'+=%|[]#*&-+/\\#!@";
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setValue((Object)symbolValue);
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.taskVariable.assertThat().field("value").is((Object)symbolValue);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable by non assigned user")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableByNonAssignedUser() throws Exception {
        UserModel nonAssigned = this.dataUser.createRandomTestUser();
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setName("new-name");
        this.taskVariable = this.restClient.authenticateUser(nonAssigned).withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable by inexistent user")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void updateTaskVariableByNonexistentUser() throws Exception {
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskVariable = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.variableModel.setName("new-name");
        this.taskVariable = this.restClient.authenticateUser(UserModel.getRandomUserModel()).withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

