/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.swagger;

import freemarker.template.TemplateException;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import java.io.BufferedReader;
import java.io.Console;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.core.swagger.Generator;
import org.alfresco.rest.core.swagger.SwaggerModel;
import org.alfresco.utility.exception.TestConfigurationException;

public class SwaggerDefinitions {
    private Swagger swagger;
    List<SwaggerModel> missingSwaggerModels = new ArrayList<SwaggerModel>();
    Path modelsPath;

    public SwaggerDefinitions(Swagger swagger) {
        this.swagger = swagger;
        this.modelsPath = Paths.get(Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile().getPath(), "src/main/java/org/alfresco/rest/model");
    }

    public void generateMissingDefinitions() {
        ArrayList<String> ignoreModel = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(Paths.get(this.modelsPath.toFile().getPath(), "ignore-models").toFile()));){
            String string;
            while ((string = br.readLine()) != null) {
                if (string.startsWith("#") || string.equals("")) continue;
                ignoreModel.add(string);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception while generating missing definitions.", e);
        }
        for (Map.Entry<String, Model> entry : this.swagger.getDefinitions().entrySet()) {
            SwaggerModel swaggerModel = new SwaggerModel(entry, this.swagger);
            if (swaggerModel.getName().matches(".*Paging|.*Entry")) {
                System.out.printf("Ignoring Model: [%s] (based on regular expression: '.*Paging|.*Entry')\n", swaggerModel.getName());
                continue;
            }
            if (ignoreModel.contains(swaggerModel.getName())) {
                System.out.printf("Ignoring Model: [%s] (based on 'ignore-models' file)\n", swaggerModel.getName());
                continue;
            }
            if (swaggerModel.exist()) continue;
            this.missingSwaggerModels.add(swaggerModel);
        }
        System.out.println(Generator.line);
        int count = 0;
        for (SwaggerModel swaggerModel : this.missingSwaggerModels) {
            if (count == 0) {
                System.out.printf("MISSING MODEL ~ THE NEW FILE THAT WILL BE GENERATED\n", new Object[0]);
                System.out.println("  0   -[Skip all]");
            }
            StringBuilder info = new StringBuilder();
            info.append("  ").append(++count).append("   -").append("[").append(swaggerModel.getName()).append("] ~ [").append(swaggerModel.getPath()).append("]");
            System.out.println(info.toString());
        }
        System.out.println("ENTER -[All Models]");
        Console console = System.console();
        if (console != null && this.missingSwaggerModels.size() > 0) {
            console.format("%s\n", Generator.line);
            console.format("\nPlease select what Models you want to generate (ex: 1,3,4) or press <<ENTER>>to generating all missing models:", new Object[0]);
            String prompt = console.readLine();
            if (prompt.equals("0")) {
                return;
            }
            if (prompt.length() == 0) {
                System.out.println("\nStart generating all models...");
                for (SwaggerModel swaggerModel : this.missingSwaggerModels) {
                    this.generateModel(swaggerModel);
                }
            } else if (prompt.contains(",")) {
                String[] modelsIDToGen = prompt.split(",");
                for (int i = 0; i < modelsIDToGen.length; ++i) {
                    this.generateSelectedSwaggerModel(modelsIDToGen[i]);
                }
            } else {
                this.generateSelectedSwaggerModel(prompt);
            }
        }
    }

    private void generateSelectedSwaggerModel(String id) {
        int choice = Integer.parseInt(id);
        if (choice - 1 >= this.missingSwaggerModels.size()) {
            throw new TestConfigurationException("You specified a wrong ID: [" + id + "] please select one value from the list displayed above. Run the command again!");
        }
        this.generateModel(this.missingSwaggerModels.get(choice - 1));
    }

    public boolean generateDefinition(String modelParamValue) {
        for (Map.Entry<String, Model> entry : this.swagger.getDefinitions().entrySet()) {
            SwaggerModel swaggerModel = new SwaggerModel(entry, this.swagger);
            if (!swaggerModel.getName().equals(modelParamValue)) continue;
            this.generateModel(swaggerModel);
            return true;
        }
        System.err.println("Model that you provided was NOT found!");
        System.err.printf("Model [%s] not found in Swagger file: %s\n", modelParamValue, this.swagger.getBasePath());
        return false;
    }

    private void generateModel(SwaggerModel swaggerModel) {
        try {
            swaggerModel.generate();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalStateException("Exception while generating model definition.", e);
        }
    }
}

