/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessVariableCoreTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel adminUser;
    private UserModel anotherUser;
    private RestProcessModel processModel;
    private RestProcessVariableModel variableModel;
    private RestProcessVariableModel processVariable;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add process variable using by the user who started the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableByUserThatStartedTheProcess() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add process variable using by a random user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableByAnyUser() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().addProcess("activitiAdhoc", this.anotherUser, false, CMISUtil.Priority.Normal);
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable is falling in case invalid type is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidTypeIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:textarea");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d:textarea")).containsSummary(String.format(RestErrorModel.UNSUPPORTED_TYPE, "d:textarea")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1938")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable is falling in case invalid type prefix is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidTypePrefixIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"ddt:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.INVALID_NAMEPACE_PREFIX, "ddt")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable is falling in case invalid value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidValueIsProvided() throws Exception {
        RestProcessVariableModel variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:int");
        variableModel.setValue("invalidValue");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format(RestErrorModel.FOR_INPUT_STRING, "invalidValue")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable is falling in case missing required variable body (name) is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfMissingRequiredVariableNameBodyIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"value\": \"missingVariableName\",\"type\": \"d:text\"}", (String)"processes/{processId}/variables/{variableName}", (String[])new String[]{this.processModel.getId(), this.variableModel.getName()});
        this.restClient.processModel(RestProcessVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.VARIABLE_NAME_REQUIRED).containsSummary(RestErrorModel.VARIABLE_NAME_REQUIRED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable is falling in case invalid variableBody (adding extra parameter in body) is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfInvalidBodyIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"scope\": \"local\",\"value\": \"testing\",\"type\": \"d:text\"}", (String)"processes/{processId}/variables/{variableName}", (String[])new String[]{this.processModel.getId(), this.variableModel.getName()});
        this.restClient.processModel(RestProcessVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"scope\"")).containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"scope\"")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable is falling in case empty name is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void failedAddingProcessVariableIfEmptyNameIsProvided() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        RestProcessVariableModel variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        variableModel.setName("");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(RestErrorModel.PUT_EMPTY_ARGUMENT).containsSummary(RestErrorModel.PUT_EMPTY_ARGUMENT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

