/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.actions.access.AccessRestrictionUtil;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestActionBodyExecTemplateModel;
import org.alfresco.rest.model.RestActionConstraintDataModel;
import org.alfresco.rest.model.RestActionConstraintModel;
import org.alfresco.rest.model.RestActionDefinitionModel;
import org.alfresco.rest.model.RestCompositeConditionDefinitionModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestParameterDefinitionModel;
import org.alfresco.rest.model.RestRuleExecutionModel;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestSimpleConditionDefinitionModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUserAIS;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RulesTestsUtils {
    static final String RULE_NAME_DEFAULT = "ruleName";
    static final String RULE_DESCRIPTION_DEFAULT = "rule description";
    static final boolean RULE_ENABLED_DEFAULT = true;
    static final boolean RULE_CASCADE_DEFAULT = true;
    static final boolean RULE_ASYNC_DEFAULT = true;
    static final boolean RULE_SHARED_DEFAULT = false;
    static final String RULE_ERROR_SCRIPT_LABEL = "Start Pooled Review and Approve Workflow";
    static final String INBOUND = "inbound";
    static final String UPDATE = "update";
    static final String OUTBOUND = "outbound";
    static final List<String> RULE_TRIGGERS_DEFAULT = List.of("inbound", "update", "outbound");
    static final boolean INVERTED = true;
    static final String AND = "and";
    static final String ID = "id";
    static final String IS_SHARED = "isShared";
    static final String AUDIO_ASPECT = "audio:audio";
    static final String LOCKABLE_ASPECT = "cm:lockable";
    static final String TEMPLATE_PARAM = "template";
    static final String RULE_SCRIPT_PARAM_ID = "script-ref";
    static final String CHECKIN_ACTION = "check-in";
    static final String LINK_CATEGORY_ACTION = "link-category";
    static final String DELETE_RENDITION_ACTION = "delete-rendition";
    static final String COPY_ACTION = "copy";
    static final String ADD_FEATURES_ACTION = "add-features";
    static final String MOVE_ACTION = "move";
    static final String SCRIPT_ACTION = "script";
    @Autowired
    private RestWrapper restClient;
    @Autowired
    private DataUserAIS dataUser;
    @Autowired
    private DataSite dataSite;
    @Autowired
    private DataContent dataContent;
    private SiteModel publicSite;
    private String reviewAndApproveWorkflowNode;
    private FolderModel copyDestinationFolder;
    private FolderModel checkOutDestinationFolder;

    public String findConstraintValue(UserModel user, String actionId, String paramId, String constraintLabel) {
        RestActionConstraintModel constraintDef = this.getConstraintsForActionParam(user, actionId, paramId);
        RestActionConstraintDataModel constraintDataModel = constraintDef.getConstraintValues().stream().filter(constraintValue -> constraintValue.getLabel().equals(constraintLabel)).findFirst().get();
        return constraintDataModel.getValue();
    }

    public RestActionConstraintModel getConstraintsForActionParam(UserModel user, String actionId, String paramId) {
        RestActionDefinitionModel actionDef = this.restClient.authenticateUser(user).withCoreAPI().usingActions().getActionDefinitionById(actionId);
        RestParameterDefinitionModel paramDef = actionDef.getParameterDefinitions().stream().filter(param -> param.getName().equals(paramId)).findFirst().get();
        if (paramDef.getParameterConstraintName() == null) {
            throw new IllegalArgumentException("Supplied parameter " + paramId + " for action " + actionId + " does not have a defined constraint.");
        }
        String constraintName = paramDef.getParameterConstraintName();
        return this.restClient.authenticateUser(user).withCoreAPI().usingActions().getActionConstraintByName(constraintName);
    }

    public String getReviewAndApproveWorkflowNode() {
        if (this.reviewAndApproveWorkflowNode == null) {
            UserModel admin = this.dataUser.getAdminUser();
            this.reviewAndApproveWorkflowNode = this.findConstraintValue(admin, SCRIPT_ACTION, RULE_SCRIPT_PARAM_ID, RULE_ERROR_SCRIPT_LABEL);
        }
        return this.reviewAndApproveWorkflowNode;
    }

    public SiteModel getPublicSite() {
        if (this.publicSite == null) {
            UserModel admin = this.dataUser.getAdminUser();
            this.publicSite = ((DataSite)this.dataSite.usingUser(admin)).createPublicRandomSite();
        }
        return this.publicSite;
    }

    public FolderModel getCopyDestinationFolder() {
        if (this.copyDestinationFolder == null) {
            UserModel admin = this.dataUser.getAdminUser();
            this.copyDestinationFolder = ((DataContent)this.dataContent.usingUser(admin).usingSite(this.getPublicSite())).createFolder();
        }
        return this.copyDestinationFolder;
    }

    public FolderModel getCheckOutDestinationFolder() {
        if (this.checkOutDestinationFolder == null) {
            UserModel admin = this.dataUser.getAdminUser();
            this.checkOutDestinationFolder = ((DataContent)this.dataContent.usingUser(admin).usingSite(this.getPublicSite())).createFolder();
        }
        return this.checkOutDestinationFolder;
    }

    public RestRuleModel createRuleModelWithModifiedValues() {
        return this.createRuleModelWithModifiedValues(List.of(this.createAddAudioAspectAction()));
    }

    public RestRuleModel createRuleModelWithModifiedValues(List<RestActionBodyExecTemplateModel> actions) {
        RestRuleModel ruleModel = this.createRuleModel(RULE_NAME_DEFAULT, actions);
        ruleModel.setDescription(RULE_DESCRIPTION_DEFAULT);
        ruleModel.setIsEnabled(true);
        ruleModel.setIsInheritable(true);
        ruleModel.setIsAsynchronous(true);
        ruleModel.setIsShared(Boolean.valueOf(false));
        ruleModel.setTriggers(RULE_TRIGGERS_DEFAULT);
        ruleModel.setErrorScript(this.getReviewAndApproveWorkflowNode());
        return ruleModel;
    }

    public RestRuleModel createRuleModelWithDefaultValues() {
        return this.createRuleModel(RULE_NAME_DEFAULT);
    }

    public RestRuleModel createInheritableRuleModel() {
        RestRuleModel ruleModel = this.createRuleModel(RULE_NAME_DEFAULT);
        ruleModel.setIsInheritable(true);
        return ruleModel;
    }

    public RestRuleModel createRuleModel(String name) {
        return this.createRuleModel(name, List.of(this.createAddAudioAspectAction()));
    }

    public RestRuleModel createRuleModel(String name, List<RestActionBodyExecTemplateModel> actions) {
        RestRuleModel ruleModel = new RestRuleModel();
        ruleModel.setIsEnabled(true);
        ruleModel.setName(name);
        ruleModel.setActions(actions);
        return ruleModel;
    }

    public RestActionBodyExecTemplateModel createAddAudioAspectAction() {
        return this.createAddAspectAction(AUDIO_ASPECT);
    }

    public RestActionBodyExecTemplateModel createAddAspectAction(String aspect) {
        return this.createCustomActionModel(ADD_FEATURES_ACTION, Map.of("aspect-name", aspect));
    }

    public RestActionBodyExecTemplateModel createCustomActionModel(String actionDefinitionId, Map<String, Serializable> params) {
        RestActionBodyExecTemplateModel restActionModel = new RestActionBodyExecTemplateModel();
        restActionModel.setActionDefinitionId(actionDefinitionId);
        restActionModel.setParams(params);
        return restActionModel;
    }

    public RestCompositeConditionDefinitionModel createEmptyConditionModel() {
        RestCompositeConditionDefinitionModel conditions = new RestCompositeConditionDefinitionModel();
        conditions.setInverted(false);
        conditions.setBooleanMode(AND);
        return conditions;
    }

    public RestCompositeConditionDefinitionModel createVariousConditions() {
        return this.createCompositeCondition(List.of(this.createCompositeCondition(false, List.of(this.createSimpleCondition("cm:created", "less_than", "2022-09-01T12:59:00.000+02:00"), this.createSimpleCondition("cm:creator", "ends", "ski"), this.createSimpleCondition("size", "greater_than", "90000000"), this.createSimpleCondition("mimetype", "equals", "video/3gpp"), this.createSimpleCondition("encoding", "equals", "utf-8"), this.createSimpleCondition("type", "equals", "cm:folder"), this.createSimpleCondition("tag", "equals", "uat"))), this.createCompositeCondition(true, List.of(this.createSimpleCondition("aspect", "equals", AUDIO_ASPECT), this.createSimpleCondition("cm:modelVersion", "begins", "1.")))));
    }

    public RestRuleModel createRuleWithVariousActions() {
        Map<String, Serializable> copyParams = Map.of("destination-folder", this.getCopyDestinationFolder().getNodeRef(), "deep-copy", true);
        RestActionBodyExecTemplateModel copyAction = this.createCustomActionModel(COPY_ACTION, copyParams);
        Map<String, String> checkOutParams = Map.of("destination-folder", this.getCheckOutDestinationFolder().getNodeRef(), "assoc-name", "cm:checkout", "assoc-type", "cm:contains");
        RestActionBodyExecTemplateModel checkOutAction = this.createCustomActionModel("check-out", checkOutParams);
        RestActionBodyExecTemplateModel counterAction = this.createCustomActionModel("counter", null);
        RestRuleModel ruleModel = this.createRuleModelWithDefaultValues();
        ruleModel.setActions(Arrays.asList(copyAction, checkOutAction, counterAction));
        return ruleModel;
    }

    public RestRuleModel createRuleWithPrivateAction() {
        RestActionBodyExecTemplateModel mailAction = new RestActionBodyExecTemplateModel();
        mailAction.setActionDefinitionId("mail");
        mailAction.setParams(AccessRestrictionUtil.createMailParameters(UserModel.getRandomUserModel(), UserModel.getRandomUserModel()));
        RestRuleModel ruleModel = this.createRuleModelWithDefaultValues();
        ruleModel.setActions(Arrays.asList(mailAction));
        return ruleModel;
    }

    public RestSimpleConditionDefinitionModel createSimpleCondition(String field, String comparator, String parameter) {
        RestSimpleConditionDefinitionModel simpleCondition = new RestSimpleConditionDefinitionModel();
        simpleCondition.setField(field);
        simpleCondition.setComparator(comparator);
        simpleCondition.setParameter(parameter);
        return simpleCondition;
    }

    public RestCompositeConditionDefinitionModel createCompositeCondition(List<RestCompositeConditionDefinitionModel> compositeConditions) {
        return this.createCompositeCondition(AND, false, compositeConditions, null);
    }

    public RestCompositeConditionDefinitionModel createCompositeCondition(boolean inverted, List<RestSimpleConditionDefinitionModel> simpleConditions) {
        return this.createCompositeCondition(AND, inverted, null, simpleConditions);
    }

    public RestRuleExecutionModel createRuleExecutionRequest() {
        return this.createRuleExecutionRequest(false);
    }

    public RestRuleExecutionModel createRuleExecutionRequest(boolean eachSubFolderIncluded) {
        RestRuleExecutionModel ruleExecutionBody = new RestRuleExecutionModel();
        ruleExecutionBody.setIsEachSubFolderIncluded(eachSubFolderIncluded);
        return ruleExecutionBody;
    }

    private RestCompositeConditionDefinitionModel createCompositeCondition(String booleanMode, boolean inverted, List<RestCompositeConditionDefinitionModel> compositeConditions, List<RestSimpleConditionDefinitionModel> simpleConditions) {
        RestCompositeConditionDefinitionModel compositeCondition = new RestCompositeConditionDefinitionModel();
        compositeCondition.setBooleanMode(booleanMode);
        compositeCondition.setInverted(inverted);
        compositeCondition.setCompositeConditions(compositeConditions);
        compositeCondition.setSimpleConditions(simpleConditions);
        return compositeCondition;
    }

    public NodeAssertion assertThat(RestNodeModel node) {
        return new NodeAssertion(this, node);
    }

    public class NodeAssertion {
        private final RestNodeModel node;

        private NodeAssertion(RulesTestsUtils this$0, RestNodeModel node) {
            this.node = node;
        }

        public NodeAssertion containsAspects(String ... expectedAspects) {
            Arrays.stream(expectedAspects).forEach(aspect -> this.node.assertThat().field("aspectNames").contains(aspect));
            return this;
        }

        public NodeAssertion notContainsAspects(String ... unexpectedAspects) {
            Arrays.stream(unexpectedAspects).forEach(aspect -> this.node.assertThat().field("aspectNames").notContains(aspect));
            return this;
        }
    }
}

