/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestCategoryLinkBodyModel;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;

abstract class CategoriesRestTest
extends RestTest {
    protected static final String INCLUDE_COUNT_PARAM = "count";
    protected static final String INCLUDE_PATH_PARAM = "path";
    protected static final String ROOT_CATEGORY_ID = "-root-";
    protected static final String CATEGORY_NAME_PREFIX = "CategoryName";
    protected static final String FIELD_NAME = "name";
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_PARENT_ID = "parentId";
    protected static final String FIELD_HAS_CHILDREN = "hasChildren";
    protected static final String FIELD_COUNT = "count";
    protected static final String FIELD_PATH = "path";
    protected UserModel user;

    CategoriesRestTest() {
    }

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        Step.STEP((String)"Create a user");
        this.user = this.dataUser.createRandomTestUser();
    }

    protected RestCategoryModelsCollection linkContentToCategories(RepoTestModel node, RestCategoryModel ... categories) {
        List categoryLinkModels = Arrays.stream(categories).map(RestCategoryModel::getId).map(this::createCategoryLinkModelWithId).collect(Collectors.toList());
        RestCategoryModelsCollection linkedCategories = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode(node).linkToCategories(categoryLinkModels);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        return linkedCategories;
    }

    protected RestCategoryModel prepareCategoryUnderRoot() {
        return this.prepareCategoryUnder(this.createCategoryModelWithId(ROOT_CATEGORY_ID));
    }

    protected RestCategoryModel prepareCategoryUnder(RestCategoryModel parentCategory) {
        RestCategoryModel categoryModel = this.createCategoryModelWithName(RandomData.getRandomName((String)CATEGORY_NAME_PREFIX));
        RestCategoryModel createdCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(parentCategory).createSingleCategory(categoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        return createdCategory;
    }

    protected List<RestCategoryModel> prepareCategoriesUnderRoot(int categoriesCount) {
        return this.prepareCategoriesUnder(ROOT_CATEGORY_ID, categoriesCount);
    }

    protected List<RestCategoryModel> prepareCategoriesUnder(String parentId, int categoriesCount) {
        RestCategoryModel parentCategory = this.createCategoryModelWithId(parentId);
        List categoryModels = IntStream.range(0, categoriesCount).mapToObj(i -> this.createCategoryModelWithName(RandomData.getRandomName((String)CATEGORY_NAME_PREFIX))).collect(Collectors.toList());
        List<RestCategoryModel> createdCategories = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(parentCategory).createCategoriesList(categoryModels).getEntries().stream().map(RestCategoryModel::onModel).collect(Collectors.toList());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        return createdCategories;
    }

    protected RestCategoryModel createCategoryModelWithId(String id) {
        return this.createCategoryModelWithIdAndName(id, null);
    }

    protected RestCategoryModel createCategoryModelWithName(String name) {
        return this.createCategoryModelWithIdAndName(null, name);
    }

    protected RestCategoryModel createCategoryModelWithIdAndName(String id, String name) {
        return RestCategoryModel.builder().id(id).name(name).create();
    }

    protected RestCategoryLinkBodyModel createCategoryLinkModelWithId(String id) {
        return RestCategoryLinkBodyModel.builder().categoryId(id).create();
    }

    protected RepoTestModel createNodeModelWithId(String id) {
        RepoTestModel nodeModel = new RepoTestModel(this){};
        nodeModel.setNodeRef(id);
        return nodeModel;
    }
}

